/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnotationModelExtension2Test {
    private static final int MODEL_COUNT = 3;
    private Document fDocument;
    private AnnotationModel fAnnotationModel;
    private AnnotationModel fNewInnerModel;
    private OldAnnotationModel fOldInnerModel;
    private Annotation fInside;
    private Annotation fBefore;
    private Annotation fAfter;
    private Annotation fInsideIn;
    private Annotation fInsideOut;
    private Annotation fBeforeIn;
    private Annotation fBoforeOut;
    private Annotation fAfterIn;
    private Annotation fAfterOut;

    @Before
    public void setUp() {
        this.fDocument = new Document("How much wood\nwould a woodchuck chuck\nif a woodchuck\ncould chuck wood?\n42");
        this.fAnnotationModel = new AnnotationModel();
        this.fNewInnerModel = new AnnotationModel();
        this.fAnnotationModel.addAnnotationModel((Object)"model1", (IAnnotationModel)this.fNewInnerModel);
        this.fOldInnerModel = new OldAnnotationModel();
        this.fAnnotationModel.addAnnotationModel((Object)"model2", (IAnnotationModel)this.fOldInnerModel);
        this.fInside = new Annotation(false);
        this.fInsideIn = new Annotation(false);
        this.fInsideOut = new Annotation(false);
        this.fBefore = new Annotation(false);
        this.fBeforeIn = new Annotation(false);
        this.fBoforeOut = new Annotation(false);
        this.fAfter = new Annotation(false);
        this.fAfterIn = new Annotation(false);
        this.fAfterOut = new Annotation(false);
        this.fAnnotationModel.connect((IDocument)this.fDocument);
    }

    @After
    public void tearDown() {
        this.fAnnotationModel.disconnect((IDocument)this.fDocument);
    }

    private void assertEquals(Annotation[] expected, Annotation[] actual, IAnnotationModel insideModel, IAnnotationModel beforeModel, IAnnotationModel afterModel) {
        HashSet<Annotation> expectedSet = new HashSet<Annotation>(Arrays.asList(expected));
        Annotation[] annotationArray = actual;
        int n = actual.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (!expectedSet.contains(a)) {
                String message = "Unexpected annotation " + this.getName(a) + " in result with models [" + this.getAnnotationModelNames(insideModel, beforeModel, afterModel) + "]";
                Assert.fail((String)message);
            }
            expectedSet.remove(a);
            ++n2;
        }
        if (!expectedSet.isEmpty()) {
            String message = "Missing annotations in result with models [" + this.getAnnotationModelNames(insideModel, beforeModel, afterModel) + "]";
            for (Annotation missing : expectedSet) {
                message = message + "\n" + this.getName(missing);
            }
            Assert.fail((String)message);
        }
    }

    private String getAnnotationModelNames(IAnnotationModel insideModel, IAnnotationModel beforeModel, IAnnotationModel afterModel) {
        return "inside: " + this.getAnnotationModelName(insideModel) + " before: " + this.getAnnotationModelName(beforeModel) + " after: " + this.getAnnotationModelName(afterModel);
    }

    private String getAnnotationModelName(IAnnotationModel model) {
        if (model == this.fAnnotationModel) {
            return "'Top'";
        }
        if (model == this.fNewInnerModel) {
            return "'New inner'";
        }
        if (model == this.fOldInnerModel) {
            return "'Old inner'";
        }
        return "'Unknown'";
    }

    private String getName(Annotation annotation) {
        Position position = this.fAnnotationModel.getPosition(annotation);
        return "[" + position.getOffset() + ", " + position.getLength() + "]";
    }

    private void addAnnotations(IAnnotationModel insideModel, IAnnotationModel beforeModel, IAnnotationModel afterModel) {
        insideModel.addAnnotation(this.fInside, new Position(10, 11));
        insideModel.addAnnotation(this.fInsideIn, new Position(11, 9));
        insideModel.addAnnotation(this.fInsideOut, new Position(9, 13));
        beforeModel.addAnnotation(this.fBefore, new Position(0, 11));
        beforeModel.addAnnotation(this.fBeforeIn, new Position(0, 12));
        beforeModel.addAnnotation(this.fBoforeOut, new Position(0, 10));
        afterModel.addAnnotation(this.fAfter, new Position(20, 11));
        afterModel.addAnnotation(this.fAfterIn, new Position(19, 12));
        afterModel.addAnnotation(this.fAfterOut, new Position(21, 10));
    }

    private void removeAnnotations() {
        this.fAnnotationModel.removeAllAnnotations();
        this.fNewInnerModel.removeAllAnnotations();
        this.fOldInnerModel.removeAllAnnotations();
    }

    private Annotation[] getAnnotations(boolean lookAhead, boolean lookBehind) {
        Iterator iterator = this.fAnnotationModel.getAnnotationIterator(10, 11, lookAhead, lookBehind);
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        while (iterator.hasNext()) {
            result.add((Annotation)iterator.next());
        }
        return result.toArray(new Annotation[result.size()]);
    }

    private void assertPermutations(boolean lookAhead, boolean lookBehind, Annotation[] expected) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    IAnnotationModel insideModel = this.getModel(i);
                    IAnnotationModel beforeModel = this.getModel(j);
                    IAnnotationModel afterModel = this.getModel(k);
                    this.addAnnotations(insideModel, beforeModel, afterModel);
                    Annotation[] actual = this.getAnnotations(lookAhead, lookBehind);
                    this.assertEquals(expected, actual, insideModel, beforeModel, afterModel);
                    this.removeAnnotations();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private IAnnotationModel getModel(int number) {
        switch (number) {
            case 0: {
                return this.fAnnotationModel;
            }
            case 1: {
                return this.fNewInnerModel;
            }
            case 2: {
                return this.fOldInnerModel;
            }
        }
        return null;
    }

    @Test
    public void testInside() throws Exception {
        Annotation[] expected = new Annotation[]{this.fInside, this.fInsideIn};
        this.assertPermutations(false, false, expected);
    }

    @Test
    public void testAhead() throws Exception {
        Annotation[] expected = new Annotation[]{this.fInside, this.fInsideIn, this.fBefore, this.fBeforeIn};
        this.assertPermutations(true, false, expected);
    }

    @Test
    public void testBehind() throws Exception {
        Annotation[] expected = new Annotation[]{this.fInside, this.fInsideIn, this.fAfter, this.fAfterIn};
        this.assertPermutations(false, true, expected);
    }

    @Test
    public void testAheadBehind() throws Exception {
        Annotation[] expected = new Annotation[]{this.fInside, this.fInsideIn, this.fInsideOut, this.fAfter, this.fAfterIn, this.fBefore, this.fBeforeIn};
        this.assertPermutations(true, true, expected);
    }

    public static class OldAnnotationModel
    implements IAnnotationModel {
        private final HashMap<Annotation, Position> fAnnotations = new HashMap();

        public void addAnnotation(Annotation annotation, Position position) {
            this.fAnnotations.put(annotation, position);
        }

        public void addAnnotationModelListener(IAnnotationModelListener listener) {
        }

        public void connect(IDocument document) {
        }

        public void disconnect(IDocument document) {
        }

        public Iterator<Annotation> getAnnotationIterator() {
            return this.fAnnotations.keySet().iterator();
        }

        public Position getPosition(Annotation annotation) {
            return this.fAnnotations.get(annotation);
        }

        public void removeAnnotation(Annotation annotation) {
            this.fAnnotations.remove(annotation);
        }

        public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        }

        public void removeAllAnnotations() {
            this.fAnnotations.clear();
        }
    }
}

