/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug401391Test {
    private Document fDocument;
    private AnnotationModel fAnnotationModel;
    private AnnotationModel fFirstInnerModel;
    private AnnotationModel fSecondInnerModel;

    @Before
    public void setUp() throws Exception {
        this.fDocument = new Document("123456789");
        this.fAnnotationModel = new AnnotationModel();
        this.fAnnotationModel.addAnnotation(new Annotation(false), new Position(0, 1));
        this.fFirstInnerModel = new AnnotationModel();
        this.fFirstInnerModel.addAnnotation(new Annotation(false), new Position(1, 2));
        this.fAnnotationModel.addAnnotationModel((Object)"first", (IAnnotationModel)this.fFirstInnerModel);
        this.fAnnotationModel.connect((IDocument)this.fDocument);
    }

    private void installAttachmentTrap() throws Exception {
        Bug401391Test.installTrap(this.fAnnotationModel, "fAttachments", () -> {
            if (this.fSecondInnerModel == null) {
                this.fSecondInnerModel = new AnnotationModel();
                this.fSecondInnerModel.addAnnotation(new Annotation(false), new Position(3, 2));
                this.fAnnotationModel.addAnnotationModel((Object)"second", (IAnnotationModel)this.fSecondInnerModel);
            } else {
                this.fAnnotationModel.removeAnnotationModel((Object)"second");
            }
        });
    }

    private static void installTrap(Object target, String fieldName, Runnable onKeySetIteration) throws Exception {
        Field fld = target.getClass().getDeclaredField(fieldName);
        fld.setAccessible(true);
        Map original = (Map)fld.get(target);
        class TrapMap
        extends AbstractMap<Object, Object> {
            private final /* synthetic */ Map val$original;
            private final /* synthetic */ Runnable val$onKeySetIteration;

            TrapMap(Map map, Runnable runnable) {
                this.val$original = map;
                this.val$onKeySetIteration = runnable;
            }

            @Override
            public Set<Object> keySet() {
                final Set delegate = this.val$original.keySet();
                return new AbstractSet<Object>(){

                    @Override
                    public Iterator<Object> iterator() {
                        Iterator<Object> result = delegate.iterator();
                        val$onKeySetIteration.run();
                        return result;
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }
                };
            }

            @Override
            public Set<Map.Entry<Object, Object>> entrySet() {
                return this.val$original.entrySet();
            }

            @Override
            public Object put(Object key, Object value) {
                return this.val$original.put(key, value);
            }
        }
        fld.set(target, new TrapMap(original, onKeySetIteration));
    }

    @After
    public void tearDown() {
        this.fAnnotationModel.disconnect((IDocument)this.fDocument);
    }

    @Test
    public void testNoConcurrentModificationOnAddAttachment() throws Exception {
        this.installAttachmentTrap();
        Assert.assertNull((Object)this.fAnnotationModel.getAnnotationModel((Object)"second"));
        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
        Assert.assertNotNull((Object)this.fAnnotationModel.getAnnotationModel((Object)"second"));
        Assert.assertEquals((long)3L, (long)this.count(iter));
    }

    @Test
    public void testNoConcurrentModificationOnRemoveAttachment() throws Exception {
        this.installAttachmentTrap();
        Assert.assertNull((Object)this.fAnnotationModel.getAnnotationModel((Object)"second"));
        this.fAnnotationModel.getAnnotationIterator();
        Assert.assertNotNull((Object)this.fAnnotationModel.getAnnotationModel((Object)"second"));
        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
        Assert.assertNull((Object)this.fAnnotationModel.getAnnotationModel((Object)"second"));
        Assert.assertEquals((long)2L, (long)this.count(iter));
    }

    @Test
    public void testRemoveAnnotationWhileIterating() throws Exception {
        Annotation removeWhileIterating = new Annotation(false);
        this.fFirstInnerModel.addAnnotation(removeWhileIterating, new Position(5, 2));
        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
        Assert.assertTrue((boolean)iter.hasNext());
        iter.next();
        Assert.assertTrue((boolean)iter.hasNext());
        iter.next();
        this.fFirstInnerModel.removeAnnotation(removeWhileIterating);
        Assert.assertEquals((long)2L, (long)this.count(this.fAnnotationModel.getAnnotationIterator()));
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertSame((Object)removeWhileIterating, iter.next());
    }

    private int count(Iterator<?> iter) {
        int result = 0;
        while (iter.hasNext()) {
            ++result;
            iter.next();
        }
        return result;
    }
}

