/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.text.tests.AbstractLineTrackerTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ConfigurableLineTrackerTest
extends AbstractLineTrackerTest {
    private int[] lineEndLengths;

    @Before
    public void setUp() {
        this.fText = new GapTextStore();
    }

    @After
    public void tearDown() {
        this.fTracker = null;
        this.fText = null;
    }

    @Override
    protected int getLineOffset(int line, int[] lines) {
        int offset = 0;
        int i = 0;
        while (i < line) {
            offset += lines[i] + this.lineEndLengths[i];
            ++i;
        }
        return offset;
    }

    private void setLegalDelimiters(String ... delimiters) {
        this.fTracker = new ConfigurableLineTracker(delimiters);
    }

    @Test
    public void testLongestMatch() throws Exception {
        this.setLegalDelimiters(DefaultLineTracker.DELIMITERS);
        this.set("xxxx\r\nxx");
        this.lineEndLengths = new int[]{2};
        this.checkLines(new int[]{4, 2});
    }

    @Test
    public void testMixedDefaultDelimiter() throws Exception {
        this.setLegalDelimiters(DefaultLineTracker.DELIMITERS);
        this.set("1234\r\n123\r1234\n1234567\r");
        this.lineEndLengths = new int[]{2, 1, 1, 1};
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[2] = 4;
        nArray[3] = 7;
        this.checkLines(nArray);
        this.set("first\r\r\nthird");
        this.lineEndLengths = new int[]{1, 2};
        int[] nArray2 = new int[3];
        nArray2[0] = 5;
        nArray2[2] = 5;
        this.checkLines(nArray2);
    }

    @Test
    public void testSingleDelimiter() throws Exception {
        this.setLegalDelimiters("\n");
        this.set("xxxx\nxx");
        this.lineEndLengths = new int[]{1};
        this.checkLines(new int[]{4, 2});
    }

    @Test
    public void testAlternativeDelimiters1() throws Exception {
        this.setLegalDelimiters("\u00a4", "\u00b6", "\u00a4\u00b6");
        this.set("xxxx\u00a4\u00b6xx");
        this.lineEndLengths = new int[]{2};
        this.checkLines(new int[]{4, 2});
    }

    @Test
    public void testAlternativeDelimiters2() throws Exception {
        this.setLegalDelimiters("{NewLine}", "[NewLine]");
        this.set("A line{NewLine}AnotherLine[NewLine}A third line[newline]End");
        this.lineEndLengths = new int[]{9};
        this.checkLines(new int[]{6, 44});
    }
}

