/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.projection.ChildDocumentManager;
import org.junit.Assert;
import org.junit.Test;

public class DocumentExtensionTest {
    @Test
    public void testAppend() {
        Listener listener = new Listener(){

            @Override
            protected Replace getReplace(DocumentEvent e) {
                String t = e.getText();
                if (t != null && !t.isEmpty()) {
                    Replace r = new Replace();
                    r.fOffset = e.getOffset() + t.length();
                    r.fLength = 0;
                    r.fText = "x";
                    return r;
                }
                return null;
            }
        };
        Document document = new Document();
        document.addDocumentListener((IDocumentListener)listener);
        try {
            document.replace(0, 0, "c");
            document.replace(0, 0, "b");
            document.replace(0, 0, "a");
        }
        catch (BadLocationException x) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)"axbxcx".equals(document.get()));
    }

    @Test
    public void testRemove() {
        Listener listener = new Listener(){

            @Override
            protected Replace getReplace(DocumentEvent e) {
                String t = e.getText();
                if (t == null || t.isEmpty()) {
                    Replace r = new Replace();
                    r.fOffset = e.getOffset();
                    r.fLength = 0;
                    r.fText = "y";
                    return r;
                }
                return null;
            }
        };
        Document document = new Document("abc");
        document.addDocumentListener((IDocumentListener)listener);
        try {
            document.replace(2, 1, "");
            document.replace(1, 1, "");
            document.replace(0, 1, "");
        }
        catch (BadLocationException x) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)"yyy".equals(document.get()));
    }

    @Test
    public void testRepeatedAppend() {
        Listener listener = new Listener(){

            @Override
            protected Replace getReplace(DocumentEvent e) {
                String t = e.getText();
                if (t != null && !t.isEmpty()) {
                    Replace r = new Replace();
                    r.fOffset = e.getOffset() + t.length();
                    r.fLength = 0;
                    r.fText = "x";
                    return r;
                }
                return null;
            }
        };
        listener.fRepetitions = 5;
        Document document = new Document();
        document.addDocumentListener((IDocumentListener)listener);
        try {
            document.replace(0, 0, "c");
            document.replace(0, 0, "b");
            document.replace(0, 0, "a");
        }
        catch (BadLocationException x) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)"axxxxxbxxxxxcxxxxx".equals(document.get()));
    }

    private List<TestDocumentEvent> createTrace(IDocument document, int repetitions) {
        ArrayList<TestDocumentEvent> trace = new ArrayList<TestDocumentEvent>();
        trace.add(new TestDocumentEvent(document, 0, 0, "c"));
        int i = 0;
        while (i < repetitions) {
            trace.add(new TestDocumentEvent(document, 1 + i, 0, "x"));
            ++i;
        }
        trace.add(new TestDocumentEvent(document, 0, 0, "b"));
        i = 0;
        while (i < repetitions) {
            trace.add(new TestDocumentEvent(document, 1 + i, 0, "x"));
            ++i;
        }
        trace.add(new TestDocumentEvent(document, 0, 0, "a"));
        i = 0;
        while (i < repetitions) {
            trace.add(new TestDocumentEvent(document, 1 + i, 0, "x"));
            ++i;
        }
        return trace;
    }

    private void internalTestChildDocument(boolean modifyParent, boolean postModifyParent, int repetitions) {
        IDocument childDocument = null;
        Document parentDocument = new Document();
        ChildDocumentManager manager = new ChildDocumentManager();
        try {
            childDocument = manager.createSlaveDocument((IDocument)parentDocument);
            if (childDocument instanceof ChildDocument) {
                ChildDocument child = (ChildDocument)childDocument;
                child.setParentDocumentRange(0, parentDocument.getLength());
            }
        }
        catch (BadLocationException x) {
            Assert.assertTrue((boolean)false);
        }
        TestDocumentListener l = new TestDocumentListener((IDocument)parentDocument, this.createTrace((IDocument)parentDocument, repetitions), this.createTrace(childDocument, repetitions));
        parentDocument.addDocumentListener((IDocumentListener)l);
        childDocument.addDocumentListener((IDocumentListener)l);
        Listener modifier = new Listener(){

            @Override
            protected Replace getReplace(DocumentEvent e) {
                String t = e.getText();
                if (t != null && !t.isEmpty()) {
                    Replace r = new Replace();
                    r.fOffset = e.getOffset() + t.length();
                    r.fLength = 0;
                    r.fText = "x";
                    return r;
                }
                return null;
            }
        };
        modifier.fRepetitions = repetitions;
        Document document = postModifyParent ? parentDocument : childDocument;
        document.addDocumentListener((IDocumentListener)modifier);
        document = modifyParent ? parentDocument : childDocument;
        try {
            document.replace(0, 0, "c");
            if (!modifier.isPostNotficationSupported()) {
                throw new UnsupportedOperationException();
            }
            document.replace(0, 0, "b");
            if (!modifier.isPostNotficationSupported()) {
                throw new UnsupportedOperationException();
            }
            document.replace(0, 0, "a");
            if (!modifier.isPostNotficationSupported()) {
                throw new UnsupportedOperationException();
            }
        }
        catch (BadLocationException x) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testChildDocumentPP() {
        this.internalTestChildDocument(true, true, 1);
    }

    @Test
    public void testChildDocumentCC() {
        try {
            this.internalTestChildDocument(false, false, 1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChildDocumentRepeatedPP() {
        this.internalTestChildDocument(true, true, 5);
    }

    @Test
    public void testChildDocumentRepeatedCC() {
        try {
            this.internalTestChildDocument(false, false, 5);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChildDocumentPC() {
        try {
            this.internalTestChildDocument(true, false, 1);
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChildDocumentCP() {
        this.internalTestChildDocument(false, true, 1);
    }

    @Test
    public void testChildDocumentRepeatedPC() {
        try {
            this.internalTestChildDocument(true, false, 5);
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChildDocumentRepeatedCP() {
        this.internalTestChildDocument(false, true, 5);
    }

    static class Listener
    implements IDocumentListener {
        int fRepetitions = 1;
        private int fInvocations = 0;
        private boolean fIsPostNotificationSupported = true;

        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            ++this.fInvocations;
        }

        public void documentChanged(DocumentEvent e) {
            if (this.fInvocations > this.fRepetitions) {
                this.fInvocations = 0;
                return;
            }
            if (e.getDocument() instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)e.getDocument();
                Replace replace = this.getReplace(e);
                if (replace != null) {
                    try {
                        extension.registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)replace);
                    }
                    catch (UnsupportedOperationException ex) {
                        this.fIsPostNotificationSupported = false;
                    }
                }
            }
        }

        protected Replace getReplace(DocumentEvent e) {
            return null;
        }

        public boolean isPostNotficationSupported() {
            return this.fIsPostNotificationSupported;
        }
    }

    static class Replace
    implements IDocumentExtension.IReplace {
        int fOffset;
        int fLength;
        String fText;

        public void perform(IDocument document, IDocumentListener owner) {
            try {
                document.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException x) {
                Assert.assertTrue((boolean)false);
            }
        }
    }

    static class TestDocumentEvent
    extends DocumentEvent {
        public TestDocumentEvent(IDocument document, int offset, int length, String text) {
            super(document, offset, length, text);
        }

        public boolean isSameAs(DocumentEvent e) {
            return e.getDocument() == this.getDocument() && e.getOffset() == this.getOffset() && e.getLength() == this.getLength() && (e.getText() == null && this.getText() == null || e.getText().equals(this.getText()));
        }
    }

    static class TestDocumentListener
    implements IDocumentListener {
        private final IDocument fDocument1;
        private final List<TestDocumentEvent> fTrace1;
        private TestDocumentEvent fExpected1;
        private final List<TestDocumentEvent> fTrace2;
        private TestDocumentEvent fExpected2;
        private boolean fPopped = false;

        public TestDocumentListener(IDocument d1, List<TestDocumentEvent> t1, List<TestDocumentEvent> t2) {
            this.fDocument1 = d1;
            this.fTrace1 = t1;
            this.fTrace2 = t2;
        }

        public void documentAboutToBeChanged(DocumentEvent received) {
            if (!this.fPopped) {
                this.fPopped = true;
                this.fExpected1 = this.fTrace1.remove(0);
                this.fExpected2 = this.fTrace2.remove(0);
            }
            TestDocumentEvent e = received.getDocument() == this.fDocument1 ? this.fExpected1 : this.fExpected2;
            Assert.assertTrue((boolean)e.isSameAs(received));
        }

        public void documentChanged(DocumentEvent received) {
            TestDocumentEvent e = received.getDocument() == this.fDocument1 ? this.fExpected1 : this.fExpected2;
            Assert.assertTrue((boolean)e.isSameAs(received));
            this.fPopped = false;
        }
    }
}

