/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.Position;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentTest {
    private Document fDocument;

    protected void checkPositions(Position[] expected) throws BadPositionCategoryException {
        Position[] actual = this.fDocument.getPositions("__dflt_position_category");
        this.checkPositions(expected, actual);
    }

    protected void checkPositions(Position[] expected, Position[] actual) {
        Assert.assertTrue((String)"invalid number of positions", (expected.length == actual.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("Position " + i + " wrong:"), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    @Before
    public void setUp() throws BadLocationException {
        this.fDocument = new Document();
        String text = "package TestPackage;\n/*\n* comment\n*/\n\tpublic class Class {\n\t\t// comment1\n\t\tpublic void method1() {\n\t\t}\n\t\t// comment2\n\t\tpublic void method2() {\n\t\t}\n\t}\n";
        this.fDocument.set(text);
        this.fDocument.addPosition(new Position(0, 20));
        this.fDocument.addPosition(new Position(21, 15));
        this.fDocument.addPosition(new Position(38, 111));
        this.fDocument.addPosition(new Position(61, 12));
        this.fDocument.addPosition(new Position(75, 27));
        this.fDocument.addPosition(new Position(105, 12));
        this.fDocument.addPosition(new Position(119, 27));
    }

    @After
    public void tearDown() {
        this.fDocument = null;
    }

    @Test
    public void testEmptyDocument() {
        Document document = new Document();
        int lines = document.getNumberOfLines();
        Assert.assertEquals((long)1L, (long)lines);
    }

    @Test
    public void testDelete1() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(21, 16, "");
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 0), new Position(22, 111), new Position(45, 12), new Position(59, 27), new Position(89, 12), new Position(103, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testEditScript1() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(0, this.fDocument.getLength(), "");
        Position[] positions = new Position[]{new Position(0, 0)};
        this.checkPositions(positions);
        this.fDocument.replace(0, 0, "\t");
        positions = new Position[]{new Position(1, 0)};
        this.checkPositions(positions);
    }

    @Test
    public void testFindPositions() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.addPosition(new Position(21, 13));
        this.fDocument.addPosition(new Position(0, 19));
        this.fDocument.addPosition(new Position(21, 14));
        this.fDocument.addPosition(new Position(21, 16));
        this.fDocument.addPosition(new Position(0, 0));
        this.fDocument.addPosition(new Position(104, 1));
        this.fDocument.addPosition(new Position(120, 1));
        this.fDocument.addPosition(new Position(119, 1));
        Position[] positions = new Position[]{new Position(0, 0), new Position(0, 19), new Position(0, 20), new Position(21, 16), new Position(21, 14), new Position(21, 13), new Position(21, 15), new Position(38, 111), new Position(61, 12), new Position(75, 27), new Position(104, 1), new Position(105, 12), new Position(119, 1), new Position(119, 27), new Position(120, 1)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert1() throws BadPositionCategoryException, BadLocationException {
        this.fDocument.replace(0, 0, "//comment\n");
        Position[] positions = new Position[]{new Position(10, 20), new Position(31, 15), new Position(48, 111), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert2() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(61, 0, "//comment\n");
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 121), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert3() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(101, 0, "//comment\n");
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 121), new Position(61, 12), new Position(75, 37), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert4() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(20, 0, "// comment");
        Position[] positions = new Position[]{new Position(0, 20), new Position(31, 15), new Position(48, 111), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace1() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(8, 11, "pkg1");
        Position[] positions = new Position[]{new Position(0, 13), new Position(14, 15), new Position(31, 111), new Position(54, 12), new Position(68, 27), new Position(98, 12), new Position(112, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace2() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(21, 16, "//comment\n");
        Position[] positions = new Position[]{new Position(0, 20), new Position(31, 0), new Position(32, 111), new Position(55, 12), new Position(69, 27), new Position(99, 12), new Position(113, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace3() throws BadLocationException {
        Position[] actual = new Position[]{new Position(0, 150)};
        this.fDocument.addPosition(actual[0]);
        this.fDocument.replace(0, 150, "xxxxxxxxxx");
        Position[] expected = new Position[]{new Position(0, 10)};
        this.checkPositions(expected, actual);
    }

    @Test
    public void testReplace4() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(19, 1, "xxxxx;");
        Position[] positions = new Position[]{new Position(0, 25), new Position(26, 15), new Position(43, 111), new Position(66, 12), new Position(80, 27), new Position(110, 12), new Position(124, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testAppend() throws BadLocationException {
        Position[] actual = new Position[]{new Position(0, 2)};
        this.fDocument.replace(0, 150, "");
        this.fDocument.replace(this.fDocument.getLength(), 0, "xx");
        this.fDocument.addPosition(actual[0]);
        this.fDocument.replace(this.fDocument.getLength(), 0, "xxxxxxxx");
        Position[] expected = new Position[]{new Position(0, 2)};
        this.checkPositions(expected, actual);
    }

    @Test
    public void testShiftLeft() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(73, 1, "");
        this.fDocument.replace(98, 1, "");
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 109), new Position(61, 12), new Position(74, 26), new Position(103, 12), new Position(117, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testShiftRight() throws BadLocationException, BadPositionCategoryException {
        this.fDocument.replace(73, 0, "\t");
        this.fDocument.replace(100, 0, "\t");
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 113), new Position(61, 12), new Position(76, 28), new Position(107, 12), new Position(121, 27)};
        this.checkPositions(positions);
    }
}

