/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExclusivePositionUpdaterTest {
    private IPositionUpdater fUpdater;
    private static final String CATEGORY = "testcategory";
    private Position fPos;
    private IDocument fDoc;

    @Before
    public void setUp() throws Exception {
        this.fUpdater = new DefaultPositionUpdater(CATEGORY);
        this.fDoc = new Document("ccccccccccccccccccccccccccccccccccccccccccccc");
        this.fPos = new Position(5, 5);
        this.fDoc.addPositionUpdater(this.fUpdater);
        this.fDoc.addPositionCategory(CATEGORY);
        this.fDoc.addPosition(CATEGORY, this.fPos);
    }

    @After
    public void tearDown() throws Exception {
        this.fDoc.removePositionUpdater(this.fUpdater);
        this.fDoc.removePositionCategory(CATEGORY);
    }

    @Test
    public void testDeleteBefore() throws BadLocationException {
        this.fDoc.replace(2, 2, "");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteRightBefore() throws BadLocationException {
        this.fDoc.replace(3, 2, "");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteOverLeftBorder() throws BadLocationException {
        this.fDoc.replace(3, 6, "");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)1L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteOverLeftBorderTillRight() throws BadLocationException {
        this.fDoc.replace(4, 6, "");
        Assert.assertEquals((long)4L, (long)this.fPos.offset);
        Assert.assertEquals((long)0L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleted() throws BadLocationException {
        this.fDoc.replace(4, 7, "");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAtOffset() throws BadLocationException {
        this.fDoc.replace(5, 1, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)4L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAtOffset2() throws BadLocationException {
        this.fDoc.replace(5, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAtOffsetTillRight() throws BadLocationException {
        this.fDoc.replace(5, 5, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)0L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAtOffsetOverRightBorder() throws BadLocationException {
        this.fDoc.replace(5, 6, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)0L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteWithin() throws BadLocationException {
        this.fDoc.replace(6, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAtRight() throws BadLocationException {
        this.fDoc.replace(8, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteOverRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)4L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testDeleteAfter() throws BadLocationException {
        this.fDoc.replace(20, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testAddBefore() throws BadLocationException {
        this.fDoc.replace(2, 0, "yy");
        Assert.assertEquals((long)7L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddRightBefore() throws BadLocationException {
        this.fDoc.replace(5, 0, "yy");
        Assert.assertEquals((long)7L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddWithin() throws BadLocationException {
        this.fDoc.replace(6, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)7L, (long)this.fPos.length);
    }

    @Test
    public void testAddWithin2() throws BadLocationException {
        this.fDoc.replace(9, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)7L, (long)this.fPos.length);
    }

    @Test
    public void testAddRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddAfter() throws BadLocationException {
        this.fDoc.replace(20, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceBefore() throws BadLocationException {
        this.fDoc.replace(2, 2, "y");
        Assert.assertEquals((long)4L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceRightBefore() throws BadLocationException {
        this.fDoc.replace(2, 3, "y");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceLeftBorder() throws BadLocationException {
        this.fDoc.replace(4, 2, "yy");
        Assert.assertEquals((long)6L, (long)this.fPos.offset);
        Assert.assertEquals((long)4L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceLeftBorderTillRight() throws BadLocationException {
        this.fDoc.replace(4, 6, "yy");
        Assert.assertEquals((long)6L, (long)this.fPos.offset);
        Assert.assertEquals((long)0L, (long)this.fPos.length);
    }

    @Test
    public void testReplaced() throws BadLocationException {
        this.fDoc.replace(4, 7, "yyyyyyy");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testReplaceAtOffset1() throws BadLocationException {
        this.fDoc.replace(5, 1, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)6L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceAtOffset2() throws BadLocationException {
        this.fDoc.replace(5, 4, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceAtOffsetTillRight() throws BadLocationException {
        this.fDoc.replace(5, 5, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)2L, (long)this.fPos.length);
        Assert.assertFalse((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testReplaceAtRight() throws BadLocationException {
        this.fDoc.replace(6, 4, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)4L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 2, "y");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceAfter() throws BadLocationException {
        this.fDoc.replace(20, 2, "y");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }
}

