/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.text.tests.AbstractGapTextTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GapTextTest
extends AbstractGapTextTest {
    @Deprecated
    @Before
    public void setUp() {
        this.fText = new AbstractGapTextTest.GapText(5, 10);
        this.fText.set("xxxxx");
    }

    @After
    public void tearDown() {
        this.fText = null;
    }

    @Test
    public void testSet() {
        this.assertGap(5, 10);
    }

    @Test
    public void testGetText1() {
        String[] expected = new String[]{"xyxxxx", "xyxyxxx", "xyxyxyxx", "xyxyxyxyx", "xyxyxyxyxy"};
        int i = 1;
        while (i < 5) {
            this.fText.replace(2 * i - 1, 0, "y");
            this.assertContents(expected[i - 1]);
            ++i;
        }
    }

    @Test
    public void testGetText2() {
        String[] expected = new String[]{"yxxxxx", "yxyxxxx", "yxyxyxxx", "yxyxyxyxx", "yxyxyxyxyx"};
        int i = 1;
        while (i < 5) {
            this.fText.replace(2 * (i - 1), 0, "y");
            this.assertContents(expected[i - 1]);
            ++i;
        }
    }

    @Test
    public void testInsert() {
        this.fText.replace(2, 0, "y");
        this.assertGap(3, 7);
        int i = 1;
        while (i <= 4) {
            this.fText.replace(2 + i, 0, "y");
            this.assertGap(3 + i, 7);
            ++i;
        }
        this.fText.replace(7, 0, "y");
        this.assertGap(8, 13);
    }

    @Test
    public void testRemoveGapOverlapping() {
        this.fText.replace(2, 2, null);
        this.assertGap(2, 9);
        this.fText.replace(1, 2, null);
        this.assertGap(1, 10);
    }

    @Test
    public void testRemoveGapOverlapping2() {
        this.fText.replace(0, 0, "aaaaazzzzzyyyyy");
        this.assertGap(15, 20);
        this.assertContents("aaaaazzzzzyyyyyxxxxx");
        this.fText.replace(5, 12, null);
        this.assertGap(5, 10);
        this.assertContents("aaaaaxxx");
    }

    @Test
    public void testRemoveRemoteFromGap() {
        this.fText.replace(0, 0, "aaaaazzzzzyyyyy");
        this.assertGap(15, 20);
        this.assertContents("aaaaazzzzzyyyyyxxxxx");
        this.fText.replace(5, 2, null);
        this.assertGap(5, 12);
        this.assertContents("aaaaazzzyyyyyxxxxx");
        this.fText.replace(7, 10, null);
        this.assertGap(7, 12);
        this.assertContents("aaaaazzx");
    }

    @Test
    public void testRemoveAtLeftGapEdge() {
        this.fText.replace(4, 0, "xxx");
        this.assertGap(7, 9);
        this.fText.replace(6, 0, "x");
        this.assertGap(7, 8);
        this.fText.replace(6, 1, null);
        this.assertGap(6, 8);
    }

    @Test
    public void testRemoveAtRightGapEdge() {
        this.fText.replace(4, 0, "xxx");
        this.assertGap(7, 9);
        this.fText.replace(6, 0, "x");
        this.assertGap(7, 8);
        this.fText.replace(7, 1, null);
        this.assertGap(7, 9);
    }

    @Test
    public void testReplace() {
        this.fText.replace(2, 2, "yy");
        this.assertGap(4, 9);
        this.fText.replace(2, 1, "yyyyyyyyyyyy");
        this.assertGap(14, 19);
        this.fText.replace(14, 0, "yyy");
        this.assertGap(17, 19);
    }

    @Test
    public void testRemoveReallocateBeforeGap() throws Exception {
        this.fText.replace(0, 0, "yyyyyzzzzz");
        this.assertGap(10, 15);
        this.assertContents("yyyyyzzzzzxxxxx");
        this.fText.replace(2, 6, null);
        this.assertGap(2, 7);
        this.assertContents("yyzzxxxxx");
    }
}

