/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.MultiStringMatcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiStringMatcherTest {
    private static MultiStringMatcher.Match run(String text, String ... needles) {
        return MultiStringMatcherTest.run(text, 0, needles);
    }

    private static MultiStringMatcher.Match run(String text, int offset, String ... needles) {
        return MultiStringMatcherTest.run(new TestCharSequence(text), offset, needles);
    }

    private static MultiStringMatcher.Match run(TestCharSequence text, int offset, String ... needles) {
        MultiStringMatcher.Match result = MultiStringMatcher.indexOf((CharSequence)text, (int)offset, (String[])needles);
        Assert.assertEquals((String)"Algorithm backtracked", (long)0L, (long)text.getBackTrack());
        return result;
    }

    private static void test(MultiStringMatcher.Match m, String expected, int index) {
        Assert.assertNotNull((String)"No match", (Object)m);
        Assert.assertEquals((String)"Unexpected match", (Object)expected, (Object)m.getText());
        Assert.assertEquals((String)"Unexpected index", (long)index, (long)m.getOffset());
    }

    private static void testList(List<MultiStringMatcher.Match> matches, String expected) {
        Collections.sort(matches, (a, b) -> {
            int cmp = Integer.compare(a.getOffset(), b.getOffset());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(a.getText().length(), b.getText().length());
        });
        Assert.assertEquals((String)"Unexpected results", (Object)expected, (Object)matches.toString());
    }

    @Test
    public void test001() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "ab", "cab");
        MultiStringMatcherTest.test(m, "cab", 5);
    }

    @Test
    public void test002() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "ab", "abc");
        MultiStringMatcherTest.test(m, "abc", 6);
    }

    @Test
    public void test003() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "ab", "cxb");
        MultiStringMatcherTest.test(m, "ab", 6);
    }

    @Test
    public void test004() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "abc", "cabx");
        MultiStringMatcherTest.test(m, "abc", 6);
    }

    @Test
    public void test005() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dacabddd", "ac", "cab");
        MultiStringMatcherTest.test(m, "ac", 1);
    }

    @Test
    public void test006() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dacabddd", "aca", "cab");
        MultiStringMatcherTest.test(m, "aca", 1);
    }

    @Test
    public void test007() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dacabddd", "acab", "cab");
        MultiStringMatcherTest.test(m, "acab", 1);
    }

    @Test
    public void test008() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddddddcac", "ac", "cab");
        MultiStringMatcherTest.test(m, "ac", 7);
    }

    @Test
    public void test009() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dddddcacddd", "cacx", "ac");
        MultiStringMatcherTest.test(m, "ac", 6);
    }

    @Test
    public void test010() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddddddcac", "ac", "cac");
        MultiStringMatcherTest.test(m, "cac", 6);
    }

    @Test
    public void test011() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("a", "a", "b", "ab");
        MultiStringMatcherTest.test(m, "a", 0);
    }

    @Test
    public void test012() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("b", "a", "b", "ab");
        MultiStringMatcherTest.test(m, "b", 0);
    }

    @Test
    public void test013() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ab", "a", "b", "ab");
        MultiStringMatcherTest.test(m, "ab", 0);
    }

    @Test
    public void test014() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("", "a", "b", "ab");
        Assert.assertNull((String)"Expected no match", (Object)m);
    }

    @Test
    public void test015() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dddca", "ac", "cac", "ab");
        Assert.assertNull((String)"Expected no match", (Object)m);
    }

    @Test
    public void test016() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ab", "ab", "b");
        MultiStringMatcherTest.test(m, "ab", 0);
    }

    @Test
    public void test017() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ushers", "he", "she", "his", "hers");
        MultiStringMatcherTest.test(m, "she", 1);
    }

    @Test
    public void test018() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dddhisheddd", "he", "she", "his", "hers");
        MultiStringMatcherTest.test(m, "his", 3);
    }

    @Test
    public void test019() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("sotat", "at", "art", "oars", "soar");
        MultiStringMatcherTest.test(m, "at", 3);
    }

    @Test
    public void test020() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("xxx", "x", "xx", "xxx");
        MultiStringMatcherTest.test(m, "xxx", 0);
    }

    @Test
    public void test021() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("xx", "x", "xx", "xxx");
        MultiStringMatcherTest.test(m, "xx", 0);
    }

    @Test
    public void test022() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("x", "x", "xx", "xxx");
        MultiStringMatcherTest.test(m, "x", 0);
    }

    @Test
    public void test023() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("Lorem\r\nIpsum", "\n", "\r\n", "\r");
        MultiStringMatcherTest.test(m, "\r\n", 5);
    }

    @Test
    public void test024() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "ab", "abcd");
        MultiStringMatcherTest.test(m, "ab", 6);
    }

    @Test
    public void test025() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dcccacabcccabcc", "abcd", "bccc");
        MultiStringMatcherTest.test(m, "bccc", 7);
    }

    @Test
    public void test026() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("xxx", 1, "x", "xx", "xxx");
        MultiStringMatcherTest.test(m, "xx", 1);
    }

    @Test
    public void test027() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("xxx", 2, "x", "xx", "xxx");
        MultiStringMatcherTest.test(m, "x", 2);
    }

    @Test
    public void test028() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("dddhisheddd", 7, "he", "she", "his", "hers");
        Assert.assertNull((String)"Expected no match", (Object)m);
    }

    @Test
    public void test029() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("Lorem001Ipsum", "1", "01", "0");
        MultiStringMatcherTest.test(m, "0", 5);
    }

    @Test
    public void test030() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("Lorem01Ipsum", "1", "01", "0");
        MultiStringMatcherTest.test(m, "01", 5);
    }

    @Test
    public void test031() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcababababababcabxdd", "ca", "cabx", "ababc");
        MultiStringMatcherTest.test(m, "ca", 2);
    }

    @Test
    public void test032() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcababcabxdd", "ca", "cabx", "cababc", "ababc");
        MultiStringMatcherTest.test(m, "cababc", 2);
    }

    @Test
    public void test033() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcababcdd", "ca", "cabx", "cababc", "ababc");
        MultiStringMatcherTest.test(m, "cababc", 2);
    }

    @Test
    public void test034() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcababcdd", "cababx", "ababc");
        MultiStringMatcherTest.test(m, "ababc", 3);
    }

    @Test
    public void test035() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcababcdd", "cababx", "abab", "ababc");
        MultiStringMatcherTest.test(m, "ababc", 3);
    }

    @Test
    public void test036() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcabababcdd", "ab", "abab", "cabababcy", "cabababcyy");
        MultiStringMatcherTest.test(m, "abab", 3);
    }

    @Test
    public void test037() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcabababcdd", "ab", "abab", "cabababc", "cabababcyy");
        MultiStringMatcherTest.test(m, "cabababc", 2);
    }

    @Test
    public void test038() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcabababcdd", "ab", "bababcd", "cabababcy", "cabababcyy");
        MultiStringMatcherTest.test(m, "ab", 3);
    }

    @Test
    public void test039() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcabababcddf", "bababcd", "bababcddf", "cabababcy", "cabababcyy");
        MultiStringMatcherTest.test(m, "bababcddf", 4);
    }

    @Test
    public void test040() throws Exception {
        MultiStringMatcher.Match m = MultiStringMatcherTest.run("ddcabababcddffxx", "ffxx", "bababcd", "bababcddffy", "cabababcy", "cabababcyy");
        MultiStringMatcherTest.test(m, "bababcd", 4);
    }

    @Test
    public void multi001() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"he", "she", "his", "hers"});
        List matches = m.find((CharSequence)"ushers", 0);
        MultiStringMatcherTest.testList(matches, "[[she, 1], [he, 2], [hers, 2]]");
    }

    @Test
    public void multi002() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"he", "she", "his", "hers"});
        List matches = m.find((CharSequence)"dddhisheddd", 0);
        MultiStringMatcherTest.testList(matches, "[[his, 3], [she, 5], [he, 6]]");
    }

    @Test
    public void multi003() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"he", "she", "his", "sh", "is"});
        List matches = m.find((CharSequence)"dddhisheddd", 0);
        MultiStringMatcherTest.testList(matches, "[[his, 3], [is, 4], [sh, 5], [she, 5], [he, 6]]");
    }

    @Test
    public void multi004() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"ab", "about", "at", "ate", "be", "bed", "edge", "get"});
        List matches = m.find((CharSequence)"abedgetab", 0);
        MultiStringMatcherTest.testList(matches, "[[ab, 0], [be, 1], [bed, 1], [edge, 2], [get, 4], [ab, 7]]");
    }

    @Test
    public void multi005() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"at", "art", "oars", "soar"});
        List matches = m.find((CharSequence)"soars", 0);
        MultiStringMatcherTest.testList(matches, "[[soar, 0], [oars, 1]]");
    }

    @Test
    public void multi006() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"at", "art", "oars", "soar"});
        List matches = m.find((CharSequence)"oart", 0);
        MultiStringMatcherTest.testList(matches, "[[art, 1]]");
    }

    @Test
    public void multi007() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"at", "art", "oars", "soar"});
        List matches = m.find((CharSequence)"soarsoars", 0);
        MultiStringMatcherTest.testList(matches, "[[soar, 0], [oars, 1], [soar, 4], [oars, 5]]");
    }

    @Test
    public void multi008() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"at", "art", "oars", "soar"});
        List matches = m.find((CharSequence)"sotat", 0);
        MultiStringMatcherTest.testList(matches, "[[at, 3]]");
    }

    @Test
    public void multi009() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"i", "in", "tin", "sting"});
        List matches = m.find((CharSequence)"sting", 0);
        MultiStringMatcherTest.testList(matches, "[[sting, 0], [tin, 1], [i, 2], [in, 2]]");
    }

    @Test
    public void multi010() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"i", "in", "tin", "sting", "hastings"});
        List matches = m.find((CharSequence)"hastings", 0);
        MultiStringMatcherTest.testList(matches, "[[hastings, 0], [sting, 2], [tin, 3], [i, 4], [in, 4]]");
    }

    @Test
    public void multi011() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"x", "xx", "xxx"});
        List matches = m.find((CharSequence)"xxx", 0);
        MultiStringMatcherTest.testList(matches, "[[x, 0], [xx, 0], [xxx, 0], [x, 1], [xx, 1], [x, 2]]");
    }

    @Test
    public void multi012() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"she", "his", "hers"});
        List matches = m.find((CharSequence)"dddhiheddd", 0);
        Assert.assertEquals((String)"Expected no match", (long)0L, (long)matches.size());
    }

    @Test
    public void multi013() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"he", "she", "his", "hers"});
        List matches = m.find((CharSequence)"dddhisheddd", 4);
        MultiStringMatcherTest.testList(matches, "[[she, 5], [he, 6]]");
    }

    @Test
    public void multi014() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.create((String[])new String[]{"x", "xx", "xxx"});
        List matches = m.find((CharSequence)"xxx", 2);
        MultiStringMatcherTest.testList(matches, "[[x, 2]]");
    }

    @Test
    public void noStrings001() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().build();
        Assert.assertNull((String)"Expected no match", (Object)m.indexOf((CharSequence)"dhihedd", 0));
        List matches = m.find((CharSequence)"dddhiheddd", 0);
        Assert.assertEquals((String)"Expected no match", (long)0L, (long)matches.size());
    }

    @Test
    public void noStrings002() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().add(new String[]{""}).build();
        Assert.assertNull((String)"Expected no match", (Object)m.indexOf((CharSequence)"dhihedd", 0));
        List matches = m.find((CharSequence)"dddhiheddd", 0);
        Assert.assertEquals((String)"Expected no match", (long)0L, (long)matches.size());
    }

    @Test
    public void noStrings003() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().add(null).build();
        Assert.assertNull((String)"Expected no match", (Object)m.indexOf((CharSequence)"dhihedd", 0));
        List matches = m.find((CharSequence)"dddhiheddd", 0);
        Assert.assertEquals((String)"Expected no match", (long)0L, (long)matches.size());
    }

    @Test
    public void fluent001() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().add(new String[]{"he", "she", "his", "hers"}).build();
        MultiStringMatcherTest.test(m.indexOf((CharSequence)"ushers", 0), "she", 1);
    }

    @Test
    public void fluent002() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().add(new String[]{"he", "she"}).add(new String[]{"his", "hers"}).build();
        MultiStringMatcherTest.testList(m.find((CharSequence)"ushers", 0), "[[she, 1], [he, 2], [hers, 2]]");
    }

    @Test
    public void fluent003() throws Exception {
        MultiStringMatcher m = MultiStringMatcher.builder().add(new String[]{"he"}).add(new String[]{null, "she", ""}).add(new String[]{"his", "hers"}).build();
        MultiStringMatcherTest.testList(m.find((CharSequence)"ushers", 0), "[[she, 1], [he, 2], [hers, 2]]");
    }

    @Test
    public void addAfterBuild() throws Exception {
        MultiStringMatcher.Builder b = MultiStringMatcher.builder().add(new String[]{"he", "she"}).add(new String[]{"his", "hers"});
        b.build();
        Assert.assertThrows(IllegalStateException.class, () -> {
            MultiStringMatcher.Builder builder2 = b.add(new String[]{"us"});
        });
    }

    @Test
    public void reuseBuilder() throws Exception {
        MultiStringMatcher.Builder b = MultiStringMatcher.builder().add(new String[]{"he", "she"}).add(new String[]{"his", "hers"});
        b.build();
        Assert.assertThrows(IllegalStateException.class, () -> {
            MultiStringMatcher multiStringMatcher = b.build();
        });
    }

    @Test
    public void scan001() throws Exception {
        TestCharSequence text = new TestCharSequence("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        MultiStringMatcher.Match m = MultiStringMatcherTest.run(text, 0, "x", "xx", "xxx", "xxxx");
        MultiStringMatcherTest.test(m, "xxxx", 0);
        Assert.assertEquals((String)"Scanned too far", (long)3L, (long)text.getLastIndex());
    }

    @Test
    public void scan002() throws Exception {
        TestCharSequence text = new TestCharSequence("ddcababababababcabxdd");
        MultiStringMatcher.Match m = MultiStringMatcherTest.run(text, 0, "ca", "cabx", "ababc");
        MultiStringMatcherTest.test(m, "ca", 2);
        Assert.assertEquals((String)"Scanned too far", (long)5L, (long)text.getLastIndex());
    }

    @Test
    public void scan003() throws Exception {
        TestCharSequence text = new TestCharSequence("ddcabarbarazz");
        MultiStringMatcher.Match m = MultiStringMatcherTest.run(text, 0, "a", "cabby", "barbara");
        MultiStringMatcherTest.test(m, "a", 3);
        Assert.assertEquals((String)"Scanned too far", (long)5L, (long)text.getLastIndex());
    }

    private static class TestCharSequence
    implements CharSequence {
        private final String value;
        private int lastIndex = -1;
        private int backtrack = 0;

        public TestCharSequence(String value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public char charAt(int index) {
            if (index < this.lastIndex) {
                this.backtrack = Math.min(this.backtrack, index - this.lastIndex);
            }
            this.lastIndex = index;
            return this.value.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        public int getBackTrack() {
            return this.backtrack;
        }
    }
}

