/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.Position;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class PositionUpdatingCornerCasesTest {
    private Document fDocument;

    protected void checkPositions(Position[] expected) throws BadPositionCategoryException {
        Position[] actual = this.fDocument.getPositions("__dflt_position_category");
        Assert.assertTrue((String)"invalid number of positions", (actual.length == expected.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)(this.print(actual[i]) + " != " + this.print(expected[i])), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    protected String print(Position p) {
        return "[" + p.getOffset() + "," + p.getLength() + "]";
    }

    @After
    public void tearDown() {
        this.fDocument = null;
    }

    @Test
    public void testInsert() throws Exception {
        this.fDocument = new Document("x-x-x-x-x-x-x-x-x-x-x");
        this.fDocument.addPosition(new Position(0, 0));
        this.fDocument.addPosition(new Position(0, 1));
        this.fDocument.addPosition(new Position(5, 0));
        this.fDocument.addPosition(new Position(5, 3));
        this.fDocument.replace(0, 0, "yy");
        Position[] positions = new Position[]{new Position(2, 1), new Position(2, 0), new Position(7, 3), new Position(7, 0)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert2() throws Exception {
        this.fDocument = new Document("x-x-x-x-x-x-x-x-x-x-x");
        this.fDocument.addPosition(new Position(0, 0));
        this.fDocument.addPosition(new Position(0, 1));
        this.fDocument.addPosition(new Position(4, 1));
        this.fDocument.addPosition(new Position(5, 0));
        this.fDocument.addPosition(new Position(5, 3));
        this.fDocument.addPosition(new Position(10, 0));
        this.fDocument.addPosition(new Position(10, 2));
        this.fDocument.replace(5, 0, "yy");
        Position[] positions = new Position[]{new Position(0, 1), new Position(0, 0), new Position(4, 1), new Position(7, 3), new Position(7, 0), new Position(12, 2), new Position(12, 0)};
        this.checkPositions(positions);
    }
}

