/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.projection.Fragment;
import org.eclipse.jface.text.projection.ProjectionMapping;
import org.eclipse.jface.text.projection.Segment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectionMappingTest {
    private IDocument fMasterDocument;
    private IDocument fSlaveDocument;
    private String fFragmentsCategory;
    private String fSegmentsCategory;
    private ProjectionMapping fProjectionMapping;

    private String getOriginalMasterContent() {
        return "1111111111111111111\n2222222222222222222\n3333333333333333333\n4444444444444444444\n5555555555555555555\n6666666666666666666\n7777777777777777777\n8888888888888888888\n99999999999999999999";
    }

    private String getOriginalSlaveContent() {
        StringBuilder buffer = new StringBuilder(this.getOriginalMasterContent());
        buffer.delete(80, 180);
        buffer.delete(40, 60);
        buffer.delete(0, 20);
        return buffer.toString();
    }

    private String getLineWrappingSlaveContent() {
        StringBuilder buffer = new StringBuilder(this.getOriginalMasterContent());
        buffer.delete(80, 180);
        buffer.delete(50, 70);
        buffer.delete(10, 30);
        return buffer.toString();
    }

    private void addProjection(int fragmentOffset, int segmentOffset, int length) {
        Segment segment;
        Fragment fragment = new Fragment(fragmentOffset, length);
        fragment.segment = segment = new Segment(segmentOffset, length);
        segment.fragment = fragment;
        try {
            this.fMasterDocument.addPosition(this.fFragmentsCategory, (Position)fragment);
            this.fSlaveDocument.addPosition(this.fSegmentsCategory, (Position)segment);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
        catch (BadPositionCategoryException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    private void createStandardProjection() {
        this.fMasterDocument.set(this.getOriginalMasterContent());
        this.fSlaveDocument.set(this.getOriginalSlaveContent());
        this.addProjection(20, 0, 20);
        this.addProjection(60, 20, 20);
    }

    private void createIdenticalProjection() {
        this.fMasterDocument.set(this.getOriginalMasterContent());
        this.fSlaveDocument.set(this.getOriginalMasterContent());
        this.addProjection(0, 0, this.fMasterDocument.getLength());
    }

    private void createLineWrappingProjection() {
        this.fMasterDocument.set(this.getOriginalMasterContent());
        this.fSlaveDocument.set(this.getLineWrappingSlaveContent());
        this.addProjection(0, 0, 10);
        this.addProjection(30, 10, 20);
        this.addProjection(70, 30, 10);
    }

    @Before
    public void setUp() {
        this.fMasterDocument = new Document();
        this.fSlaveDocument = new Document();
        this.fFragmentsCategory = "_fragments" + this.fSlaveDocument.hashCode();
        this.fSegmentsCategory = "_segments" + this.fMasterDocument.hashCode();
        this.fMasterDocument.addPositionCategory(this.fFragmentsCategory);
        this.fSlaveDocument.addPositionCategory(this.fSegmentsCategory);
        this.fProjectionMapping = new ProjectionMapping(this.fMasterDocument, this.fFragmentsCategory, this.fSlaveDocument, this.fSegmentsCategory);
    }

    @After
    public void tearDown() {
        this.fMasterDocument = null;
        this.fSlaveDocument = null;
        this.fFragmentsCategory = null;
        this.fSegmentsCategory = null;
        this.fProjectionMapping = null;
    }

    @Test
    public void test1() {
        this.createStandardProjection();
        IRegion coverage = this.fProjectionMapping.getCoverage();
        Assert.assertTrue((coverage.getOffset() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((coverage.getLength() == 60 ? 1 : 0) != 0);
    }

    @Test
    public void test2() {
        this.createStandardProjection();
        try {
            Assert.assertEquals((long)20L, (long)this.fProjectionMapping.toOriginOffset(0));
            Assert.assertEquals((long)25L, (long)this.fProjectionMapping.toOriginOffset(5));
            Assert.assertEquals((long)60L, (long)this.fProjectionMapping.toOriginOffset(20));
            Assert.assertEquals((long)65L, (long)this.fProjectionMapping.toOriginOffset(25));
            Assert.assertEquals((long)80L, (long)this.fProjectionMapping.toOriginOffset(40));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
        try {
            this.fProjectionMapping.toOriginOffset(41);
            Assert.assertTrue((boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Test
    public void test3a() {
        this.createStandardProjection();
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(5, 10));
            Assert.assertEquals((Object)new Region(25, 10), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(25, 10));
            Assert.assertEquals((Object)new Region(65, 10), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test3b() {
        this.createStandardProjection();
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 20));
            Assert.assertEquals((Object)new Region(20, 20), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(20, 20));
            Assert.assertEquals((Object)new Region(60, 20), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test3c() {
        this.createStandardProjection();
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(10, 20));
            Assert.assertEquals((Object)new Region(30, 40), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 40));
            Assert.assertEquals((Object)new Region(20, 60), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test3d() {
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 0));
            Assert.assertEquals((Object)new Region(0, this.fMasterDocument.getLength()), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
        try {
            this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 2));
            Assert.assertTrue((boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.fProjectionMapping.toOriginRegion((IRegion)new Region(2, 2));
            Assert.assertTrue((boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Test
    public void test3e() {
        this.createIdenticalProjection();
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 0));
            Assert.assertEquals((Object)new Region(0, 0), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(20, 40));
            Assert.assertEquals((Object)new Region(20, 40), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(this.fMasterDocument.getLength(), 0));
            Assert.assertEquals((Object)new Region(this.fMasterDocument.getLength(), 0), (Object)origin);
            origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, this.fMasterDocument.getLength()));
            Assert.assertEquals((Object)new Region(0, this.fMasterDocument.getLength()), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test3f() {
        this.fMasterDocument.set("abc\n");
        this.fSlaveDocument.set("");
        this.addProjection(4, 0, 0);
        try {
            IRegion origin = this.fProjectionMapping.toOriginRegion((IRegion)new Region(0, 0));
            Assert.assertEquals((Object)new Region(4, 0), (Object)origin);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test4() {
        this.createLineWrappingProjection();
        Assert.assertEquals((long)3L, (long)this.fSlaveDocument.getNumberOfLines());
        try {
            IRegion lines = this.fProjectionMapping.toOriginLines(0);
            Assert.assertEquals((Object)new Region(0, 2), (Object)lines);
            lines = this.fProjectionMapping.toOriginLines(1);
            Assert.assertEquals((Object)new Region(2, 2), (Object)lines);
            lines = this.fProjectionMapping.toOriginLines(2);
            Assert.assertEquals((Object)new Region(4, 1), (Object)lines);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test5a() {
        this.createStandardProjection();
        Assert.assertEquals((long)3L, (long)this.fSlaveDocument.getNumberOfLines());
        try {
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toOriginLine(0));
            Assert.assertEquals((long)3L, (long)this.fProjectionMapping.toOriginLine(1));
            Assert.assertEquals((long)4L, (long)this.fProjectionMapping.toOriginLine(2));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test5b() {
        this.createLineWrappingProjection();
        try {
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toOriginLine(0));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toOriginLine(1));
            Assert.assertEquals((long)4L, (long)this.fProjectionMapping.toOriginLine(2));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test6() {
        this.createStandardProjection();
        try {
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toImageOffset(20));
            Assert.assertEquals((long)39L, (long)this.fProjectionMapping.toImageOffset(79));
            Assert.assertEquals((long)40L, (long)this.fProjectionMapping.toImageOffset(80));
            Assert.assertEquals((long)20L, (long)this.fProjectionMapping.toImageOffset(60));
            Assert.assertEquals((long)19L, (long)this.fProjectionMapping.toImageOffset(39));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageOffset(40));
            Assert.assertEquals((long)10L, (long)this.fProjectionMapping.toImageOffset(30));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageOffset(45));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    private IRegion computeImageRegion(IRegion region, boolean exact) throws BadLocationException {
        if (exact) {
            return this.fProjectionMapping.toExactImageRegion(region);
        }
        return this.fProjectionMapping.toImageRegion(region);
    }

    private void commonSubSection_toImageRegion(boolean exact) {
        try {
            IRegion imageRegion = this.computeImageRegion((IRegion)new Region(25, 10), exact);
            Assert.assertEquals((Object)new Region(5, 10), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(25, 0), exact);
            Assert.assertEquals((Object)new Region(5, 0), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(20, 20), exact);
            Assert.assertEquals((Object)new Region(0, 20), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(25, 50), exact);
            Assert.assertEquals((Object)new Region(5, 30), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(20, 60), exact);
            Assert.assertEquals((Object)new Region(0, 40), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(45, 10), exact);
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(80, 0), exact);
            Assert.assertEquals((Object)new Region(40, 0), (Object)imageRegion);
            imageRegion = this.computeImageRegion((IRegion)new Region(80, 10), exact);
            Assert.assertEquals(null, (Object)imageRegion);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test7() {
        this.createStandardProjection();
        this.commonSubSection_toImageRegion(true);
        try {
            IRegion imageRegion = this.fProjectionMapping.toExactImageRegion((IRegion)new Region(40, 20));
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toExactImageRegion((IRegion)new Region(25, 30));
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toExactImageRegion((IRegion)new Region(45, 30));
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toExactImageRegion((IRegion)new Region(45, 50));
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toExactImageRegion((IRegion)new Region(15, 70));
            Assert.assertEquals(null, (Object)imageRegion);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test8() {
        this.createStandardProjection();
        this.commonSubSection_toImageRegion(false);
        try {
            IRegion imageRegion = this.fProjectionMapping.toImageRegion((IRegion)new Region(40, 20));
            Assert.assertEquals(null, (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toImageRegion((IRegion)new Region(25, 30));
            Assert.assertEquals((Object)new Region(5, 15), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toImageRegion((IRegion)new Region(45, 30));
            Assert.assertEquals((Object)new Region(20, 15), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toImageRegion((IRegion)new Region(45, 50));
            Assert.assertEquals((Object)new Region(20, 20), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toImageRegion((IRegion)new Region(15, 70));
            Assert.assertEquals((Object)new Region(0, 40), (Object)imageRegion);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test8b() {
        this.createStandardProjection();
        try {
            IRegion imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(25, 10));
            Assert.assertEquals((Object)new Region(5, 10), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(25, 0));
            Assert.assertEquals((Object)new Region(5, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(20, 20));
            Assert.assertEquals((Object)new Region(0, 20), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(25, 50));
            Assert.assertEquals((Object)new Region(5, 30), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(20, 60));
            Assert.assertEquals((Object)new Region(0, 40), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(45, 10));
            Assert.assertEquals((Object)new Region(20, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(80, 0));
            Assert.assertEquals((Object)new Region(40, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(80, 10));
            Assert.assertEquals((Object)new Region(40, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(10, 5));
            Assert.assertEquals((Object)new Region(0, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(40, 20));
            Assert.assertEquals((Object)new Region(20, 0), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(25, 30));
            Assert.assertEquals((Object)new Region(5, 15), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(45, 30));
            Assert.assertEquals((Object)new Region(20, 15), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(45, 50));
            Assert.assertEquals((Object)new Region(20, 20), (Object)imageRegion);
            imageRegion = this.fProjectionMapping.toClosestImageRegion((IRegion)new Region(15, 70));
            Assert.assertEquals((Object)new Region(0, 40), (Object)imageRegion);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test9a() {
        this.createLineWrappingProjection();
        try {
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toImageLine(0));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toImageLine(1));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toImageLine(2));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toImageLine(3));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toImageLine(4));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(5));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(6));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(7));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(8));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(9));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test9b() {
        this.fMasterDocument.set("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        this.fSlaveDocument.set("\n\n\n\n\n\n");
        this.addProjection(3, 0, 3);
        this.addProjection(9, 3, 3);
        Assert.assertEquals((long)16L, (long)this.fMasterDocument.getNumberOfLines());
        Assert.assertEquals((long)7L, (long)this.fSlaveDocument.getNumberOfLines());
        try {
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(0));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(1));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(2));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toImageLine(3));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toImageLine(4));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toImageLine(5));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(6));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(7));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(8));
            Assert.assertEquals((long)3L, (long)this.fProjectionMapping.toImageLine(9));
            Assert.assertEquals((long)4L, (long)this.fProjectionMapping.toImageLine(10));
            Assert.assertEquals((long)5L, (long)this.fProjectionMapping.toImageLine(11));
            Assert.assertEquals((long)6L, (long)this.fProjectionMapping.toImageLine(12));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(13));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(14));
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toImageLine(15));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test10a() {
        this.createLineWrappingProjection();
        try {
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(0));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(1));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toClosestImageLine(2));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toClosestImageLine(3));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(4));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(5));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(6));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(7));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(8));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(9));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test10b() {
        try {
            Assert.assertEquals((long)-1L, (long)this.fProjectionMapping.toClosestImageLine(0));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test10c() {
        this.fMasterDocument.set("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        this.fSlaveDocument.set("\n\n\n\n\n\n");
        this.addProjection(3, 0, 3);
        this.addProjection(9, 3, 3);
        Assert.assertEquals((long)16L, (long)this.fMasterDocument.getNumberOfLines());
        Assert.assertEquals((long)7L, (long)this.fSlaveDocument.getNumberOfLines());
        try {
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(0));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(1));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(2));
            Assert.assertEquals((long)0L, (long)this.fProjectionMapping.toClosestImageLine(3));
            Assert.assertEquals((long)1L, (long)this.fProjectionMapping.toClosestImageLine(4));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(5));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(6));
            Assert.assertEquals((long)2L, (long)this.fProjectionMapping.toClosestImageLine(7));
            Assert.assertEquals((long)3L, (long)this.fProjectionMapping.toClosestImageLine(8));
            Assert.assertEquals((long)3L, (long)this.fProjectionMapping.toClosestImageLine(9));
            Assert.assertEquals((long)4L, (long)this.fProjectionMapping.toClosestImageLine(10));
            Assert.assertEquals((long)5L, (long)this.fProjectionMapping.toClosestImageLine(11));
            Assert.assertEquals((long)6L, (long)this.fProjectionMapping.toClosestImageLine(12));
            Assert.assertEquals((long)6L, (long)this.fProjectionMapping.toClosestImageLine(13));
            Assert.assertEquals((long)6L, (long)this.fProjectionMapping.toClosestImageLine(14));
            Assert.assertEquals((long)6L, (long)this.fProjectionMapping.toClosestImageLine(15));
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    private void assertRegions(IRegion[] expected, IRegion[] actual) {
        Assert.assertTrue((String)"invalid number of regions", (expected.length == actual.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    @Test
    public void test11a() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(0, this.fSlaveDocument.getLength()));
            IRegion[] expected = new IRegion[]{new Region(20, 20), new Region(60, 20)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11b() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(5, 10));
            IRegion[] expected = new IRegion[]{new Region(25, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11c() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(0, 10));
            IRegion[] expected = new IRegion[]{new Region(20, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11d() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(10, 10));
            IRegion[] expected = new IRegion[]{new Region(30, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11e() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(0, 20));
            IRegion[] expected = new IRegion[]{new Region(20, 20)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11f() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(0, 0));
            IRegion[] expected = new IRegion[]{new Region(20, 0)};
            this.assertRegions(expected, actual);
            actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(20, 0));
            expected = new IRegion[]{new Region(60, 0)};
            this.assertRegions(expected, actual);
            actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(40, 0));
            expected = new IRegion[]{new Region(80, 0)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11g() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(10, 20));
            IRegion[] expected = new IRegion[]{new Region(30, 10), new Region(60, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11h() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(30, 10));
            IRegion[] expected = new IRegion[]{new Region(70, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test11i() {
        this.createIdenticalProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactOriginRegions((IRegion)new Region(30, 10));
            IRegion[] expected = new IRegion[]{new Region(30, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12a() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(0, this.fMasterDocument.getLength()));
            IRegion[] expected = new IRegion[]{new Region(0, 20), new Region(20, 20)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12b() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(25, 10));
            IRegion[] expected = new IRegion[]{new Region(5, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12c() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(20, 10));
            IRegion[] expected = new IRegion[]{new Region(0, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12d() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(30, 10));
            IRegion[] expected = new IRegion[]{new Region(10, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12e() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(20, 20));
            IRegion[] expected = new IRegion[]{new Region(0, 20)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12f() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(20, 0));
            IRegion[] expected = new IRegion[]{new Region(0, 0)};
            this.assertRegions(expected, actual);
            actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(60, 0));
            expected = new IRegion[]{new Region(20, 0)};
            this.assertRegions(expected, actual);
            actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(80, 0));
            expected = new IRegion[]{new Region(40, 0)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12g() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(30, 40));
            IRegion[] expected = new IRegion[]{new Region(10, 10), new Region(20, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12h() {
        this.createStandardProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(70, 10));
            IRegion[] expected = new IRegion[]{new Region(30, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test12i() {
        this.createIdenticalProjection();
        try {
            IRegion[] actual = this.fProjectionMapping.toExactImageRegions((IRegion)new Region(30, 10));
            IRegion[] expected = new IRegion[]{new Region(30, 10)};
            this.assertRegions(expected, actual);
        }
        catch (BadLocationException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test13a() {
        Assert.assertEquals((long)0L, (long)this.fProjectionMapping.getImageLength());
    }

    @Test
    public void test13b() {
        this.createIdenticalProjection();
        Assert.assertEquals((long)this.fSlaveDocument.getLength(), (long)this.fProjectionMapping.getImageLength());
    }

    @Test
    public void test13c() {
        this.createStandardProjection();
        Assert.assertEquals((long)this.fSlaveDocument.getLength(), (long)this.fProjectionMapping.getImageLength());
    }

    @Test
    public void test13d() {
        this.createLineWrappingProjection();
        Assert.assertEquals((long)this.fSlaveDocument.getLength(), (long)this.fProjectionMapping.getImageLength());
    }
}

