/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.AbstractLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextUtilities;
import org.junit.Assert;
import org.junit.Test;

public class TextUtilitiesTest {
    private static DocumentEvent createRandomEvent(IDocument document, int maxLength, char character) {
        int index0 = (int)(Math.random() * (double)(maxLength + 1));
        int index1 = (int)(Math.random() * (double)(maxLength + 1));
        int offset = Math.min(index0, index1);
        int length = Math.max(index0, index1) - offset;
        int stringLength = (int)(Math.random() * 10.0);
        StringBuilder buffer = new StringBuilder(stringLength);
        int i = 0;
        while (i < stringLength) {
            buffer.append(character);
            ++i;
        }
        return new DocumentEvent(document, offset, length, buffer.toString());
    }

    @Test
    public void testMergeEvents1() {
        Document reference = new Document();
        LazilyMirroredDocument testee = new LazilyMirroredDocument((IDocument)reference);
        try {
            reference.replace(0, 0, "01234567890123");
            TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
            reference.replace(4, 3, "moo ");
            reference.replace(9, 2, "asd");
            TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
        }
        catch (BadLocationException e) {
            Assert.fail((String)"bad location exception");
        }
    }

    @Test
    public void testMergeEvents() {
        Document reference = new Document();
        LazilyMirroredDocument testee = new LazilyMirroredDocument((IDocument)reference);
        try {
            ArrayList<DocumentEvent> events = new ArrayList<DocumentEvent>();
            int currentLength = 0;
            events.add(new DocumentEvent((IDocument)reference, 0, 0, "foo bar goo haa"));
            events.add(new DocumentEvent((IDocument)reference, 0, "foo bar goo haa".length(), "foo bar goo haa"));
            events.add(new DocumentEvent((IDocument)reference, 4, 4, "xxxx"));
            events.add(new DocumentEvent((IDocument)reference, 4, 4, "yyy"));
            events.add(new DocumentEvent((IDocument)reference, 4, 3, "moo "));
            events.add(new DocumentEvent((IDocument)reference, 9, 2, "asd"));
            events.add(new DocumentEvent((IDocument)reference, 0, 2, "asd"));
            for (DocumentEvent event : events) {
                currentLength += event.getText().length() - event.getLength();
            }
            int i = 0;
            while (i < 500) {
                char character = (char)(32 + i % 95);
                DocumentEvent event = TextUtilitiesTest.createRandomEvent((IDocument)reference, currentLength, character);
                currentLength += event.getText().length() - event.getLength();
                events.add(event);
                ++i;
            }
            for (DocumentEvent event : events) {
                reference.replace(event.getOffset(), event.getLength(), event.getText());
                if (!(Math.random() < 0.3)) continue;
                TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
            }
            TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
        }
        catch (BadLocationException e) {
            Assert.fail((String)"bad location exception");
        }
    }

    @Test
    public void testMergeEvents2() {
        Document reference = new Document();
        LazilyMirroredDocument2 testee = new LazilyMirroredDocument2((IDocument)reference);
        try {
            ArrayList<DocumentEvent> events = new ArrayList<DocumentEvent>();
            int currentLength = 0;
            events.add(new DocumentEvent((IDocument)reference, 0, 0, "foo bar goo haa"));
            events.add(new DocumentEvent((IDocument)reference, 0, "foo bar goo haa".length(), "foo bar goo haa"));
            events.add(new DocumentEvent((IDocument)reference, 4, 4, "xxxx"));
            events.add(new DocumentEvent((IDocument)reference, 4, 4, "yyy"));
            events.add(new DocumentEvent((IDocument)reference, 4, 3, "moo "));
            events.add(new DocumentEvent((IDocument)reference, 9, 2, "asd"));
            events.add(new DocumentEvent((IDocument)reference, 0, 2, "asd"));
            for (DocumentEvent event : events) {
                currentLength += event.getText().length() - event.getLength();
            }
            int i = 0;
            while (i < 500) {
                char character = (char)(32 + i % 95);
                DocumentEvent event = TextUtilitiesTest.createRandomEvent((IDocument)reference, currentLength, character);
                currentLength += event.getText().length() - event.getLength();
                events.add(event);
                ++i;
            }
            for (DocumentEvent event : events) {
                reference.replace(event.getOffset(), event.getLength(), event.getText());
                if (!(Math.random() < 0.3)) continue;
                TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
            }
            TextUtilitiesTest.check((IDocument)reference, (IDocument)testee);
        }
        catch (BadLocationException e) {
            Assert.fail((String)"bad location exception");
        }
    }

    private static void check(IDocument reference, IDocument testee) {
        Assert.assertEquals((Object)reference.get(), (Object)testee.get());
    }

    @Test
    public void testIndexOf() {
        int[] result = TextUtilities.indexOf((String[])new String[0], (String)"xxxxxxxxxx", (int)0);
        Assert.assertEquals((long)-1L, (long)result[0]);
        Assert.assertEquals((long)-1L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"a", "ab", "abc"}, (String)"xxxxxxxxxx", (int)0);
        Assert.assertEquals((long)-1L, (long)result[0]);
        Assert.assertEquals((long)-1L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"a", "ab", "abc"}, (String)"foobarabcd", (int)0);
        Assert.assertEquals((long)4L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"ab", "ab"}, (String)"foobarabcd", (int)0);
        Assert.assertEquals((long)6L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"", "ab", "abc"}, (String)"foobarabcd", (int)0);
        Assert.assertEquals((long)6L, (long)result[0]);
        Assert.assertEquals((long)2L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"arac", "", "fuu"}, (String)"foobarabcd", (int)0);
        Assert.assertEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)1L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"", ""}, (String)"foobarabcd", (int)0);
        Assert.assertEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)1L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{""}, (String)"foobarabcd", (int)5);
        Assert.assertEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"abc"}, (String)"foobarabcd", (int)-5);
        Assert.assertEquals((long)6L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        result = TextUtilities.indexOf((String[])new String[]{"abc"}, (String)"foobarabcd", (int)20);
        Assert.assertEquals((long)-1L, (long)result[0]);
        Assert.assertEquals((long)-1L, (long)result[1]);
        try {
            TextUtilities.indexOf(null, (String)"foobarabcd", (int)0);
            Assert.fail((String)"Exception not thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            String[] stringArray = new String[2];
            stringArray[0] = "abc";
            TextUtilities.indexOf((String[])stringArray, (String)"foobarabcd", (int)0);
            Assert.fail((String)"Exception not thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TextUtilities.indexOf((String[])new String[]{"abc"}, null, (int)0);
            Assert.fail((String)"Exception not thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNextDelimiter() {
        AbstractLineTracker.DelimiterInfo result = TextUtilities.nextDelimiter((CharSequence)"abc\ndef", (int)0);
        Assert.assertEquals((long)3L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\n", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc\ndef", (int)5);
        Assert.assertEquals((long)-1L, (long)result.delimiterIndex);
        Assert.assertEquals(null, (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc\rdef\n123", (int)0);
        Assert.assertEquals((long)3L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\r", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc+\r\ndef\n123", (int)0);
        Assert.assertEquals((long)4L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\r\n", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc~>\r\r\ndef\n123", (int)0);
        Assert.assertEquals((long)5L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\r", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"\nabc~>\r\r\ndef\n123", (int)0);
        Assert.assertEquals((long)0L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\n", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc~>123\r\n", (int)0);
        Assert.assertEquals((long)8L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\r\n", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc~>\r\r\ndef\n123", (int)9);
        Assert.assertEquals((long)11L, (long)result.delimiterIndex);
        Assert.assertEquals((Object)"\n", (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"", (int)0);
        Assert.assertEquals((long)-1L, (long)result.delimiterIndex);
        Assert.assertEquals(null, (Object)result.delimiter);
        result = TextUtilities.nextDelimiter((CharSequence)"abc123", (int)0);
        Assert.assertEquals((long)-1L, (long)result.delimiterIndex);
        Assert.assertEquals(null, (Object)result.delimiter);
    }

    private static class LazilyMirroredDocument
    extends Document {
        private final DocumentListener fDocumentListener = new DocumentListener();
        private final List<DocumentEvent> fEvents = new ArrayList<DocumentEvent>();

        public LazilyMirroredDocument(IDocument document) {
            document.addDocumentListener((IDocumentListener)this.fDocumentListener);
        }

        private void flush() throws BadLocationException {
            DocumentEvent event = TextUtilities.mergeUnprocessedDocumentEvents((IDocument)this, this.fEvents);
            if (event == null) {
                return;
            }
            this.replace(event.getOffset(), event.getLength(), event.getText());
            this.fEvents.clear();
        }

        public String get() {
            try {
                this.flush();
            }
            catch (BadLocationException e) {
                Assert.assertFalse((boolean)true);
            }
            return super.get();
        }

        private final class DocumentListener
        implements IDocumentListener {
            private DocumentListener() {
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                LazilyMirroredDocument.this.fEvents.add(event);
            }
        }
    }

    private static class LazilyMirroredDocument2
    extends Document {
        private final DocumentListener fDocumentListener = new DocumentListener();
        private final List<DocumentEvent> fEvents = new ArrayList<DocumentEvent>();

        public LazilyMirroredDocument2(IDocument document) {
            document.addDocumentListener((IDocumentListener)this.fDocumentListener);
        }

        private void flush() throws BadLocationException {
            DocumentEvent event = TextUtilities.mergeProcessedDocumentEvents(this.fEvents);
            if (event == null) {
                return;
            }
            this.replace(event.getOffset(), event.getLength(), event.getText());
            this.fEvents.clear();
        }

        public String get() {
            try {
                this.flush();
            }
            catch (BadLocationException e) {
                Assert.fail((String)"bad implementation");
            }
            return super.get();
        }

        private final class DocumentListener
        implements IDocumentListener {
            private DocumentListener() {
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                event = new DocumentEvent(event.getDocument(), event.getOffset(), event.getLength(), event.getText());
                LazilyMirroredDocument2.this.fEvents.add(event);
            }
        }
    }
}

