/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.link;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.junit.Assert;
import org.junit.Test;

public class LinkedPositionGroupTest {
    private static final String GARTEN = "\tMARGARETE:\n\tVersprich mir, Heinrich!\n\t \n\tFAUST:\n\tWas ich kann!\n\t \n\tMARGARETE:\n\tNun sag, wie hast du's mit der Religion?\n\tDu bist ein herzlich guter Mann,\n\tAllein ich glaub, du haeltst nicht viel davon.\n\t \n\tFAUST:\n\tLass das, mein Kind! Du fuehlst, ich bin dir gut;\n\tFuer meine Lieben liess' ich Leib und Blut,\n\tWill niemand sein Gefuehl und seine Kirche rauben.\n\t \n\tMARGARETE:\n\tDas ist nicht recht, man muss dran glauben.\n\t \n\tFAUST:\n\tMuss man?\n\t \n\tMARGARETE:\n\tAch! wenn ich etwas auf dich konnte! Du ehrst auch nicht die heil'gen Sakramente.\n\t \n\tFAUST:\n\tIch ehre sie.\n\t \n\tMARGARETE:\n\tDoch ohne Verlangen. Zur Messe, zur Beichte bist du lange nicht gegangen.\n\tGlaubst du an Gott?\n\t \n\tFAUST:\n\tMein Liebchen, wer darf sagen: Ich glaub an Gott?\n\tMagst Priester oder Weise fragen,\n\tUnd ihre Antwort scheint nur Spott\n\tUeber den Frager zu sein.\n\t \n\tMARGARETE:\n\tSo glaubst du nicht?\n\t \n\tFAUST:\n\tMisshoer mich nicht, du holdes Angesicht!\n\tWer darf ihn nennen?\n\tUnd wer bekennen:\n\t\"Ich glaub ihn!\"?\n\tWer empfinden,\n\tUnd sich unterwinden\n\tZu sagen: \"Ich glaub ihn nicht!\"?\n\tDer Allumfasser,\n\tDer Allerhalter,\n\tFasst und erhaelt er nicht\n\tDich, mich, sich selbst?\n\tWoelbt sich der Himmel nicht da droben?\n\tLiegt die Erde nicht hier unten fest?\n\tUnd steigen freundlich blickend\n\tEwige Sterne nicht herauf?\n\tSchau ich nicht Aug in Auge dir,\n\tUnd draengt nicht alles\n\tNach Haupt und Herzen dir,\n\tUnd webt in ewigem Geheimnis\n\tUnsichtbar sichtbar neben dir?\n\tErfuell davon dein Herz, so gross es ist,\n\tUnd wenn du ganz in dem Gefuehle selig bist,\n\tNenn es dann, wie du willst,\n\tNenn's Glueck! Herz! Liebe! Gott\n\tIch habe keinen Namen\n\tDafuer! Gefuehl ist alles;\n\tName ist Schall und Rauch,\n\tUmnebelnd Himmelsglut.\n";

    @Test
    public void testIsEmpty() {
        LinkedPositionGroup group = new LinkedPositionGroup();
        Assert.assertTrue((boolean)group.isEmpty());
    }

    @Test
    public void testIsNotEmtpy() throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        group.addPosition(new LinkedPosition((IDocument)new Document(), 0, 0));
        Assert.assertFalse((boolean)group.isEmpty());
    }

    @Test
    public void testGetPositions() throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        group.addPosition(new LinkedPosition((IDocument)new Document(), 0, 0));
        group.addPosition(new LinkedPosition((IDocument)new Document(), 0, 0));
        Assert.assertEquals((long)2L, (long)group.getPositions().length);
    }

    @Test
    public void testAddPosition() throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedPosition p = new LinkedPosition((IDocument)new Document(), 0, 0);
        group.addPosition(p);
        Assert.assertSame((Object)p, (Object)group.getPositions()[0]);
    }

    @Test
    public void testAddIllegalState() throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group);
        LinkedPosition p = new LinkedPosition((IDocument)new Document(), 0, 0);
        try {
            group.addPosition(p);
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testAddBadLocation() throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        Document doc = new Document(GARTEN);
        group.addPosition(new LinkedPosition((IDocument)doc, 1, 9));
        try {
            group.addPosition(new LinkedPosition((IDocument)doc, 3, 9));
        }
        catch (BadLocationException e) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testAddEqualContent() {
        LinkedPositionGroup group = new LinkedPositionGroup();
        Document doc = new Document(GARTEN);
        try {
            group.addPosition(new LinkedPosition((IDocument)doc, 1, 9));
            group.addPosition(new LinkedPosition((IDocument)doc, 68, 9));
        }
        catch (BadLocationException e) {
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testAddNotEqualContent() {
        LinkedPositionGroup group = new LinkedPositionGroup();
        Document doc = new Document(GARTEN);
        try {
            group.addPosition(new LinkedPosition((IDocument)doc, GARTEN.indexOf("das"), 3));
            group.addPosition(new LinkedPosition((IDocument)doc, GARTEN.indexOf("Das"), 3));
        }
        catch (BadLocationException e) {
            Assert.assertFalse((boolean)true);
        }
    }
}

