/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateTranslatorTest {
    private TemplateTranslator fTranslator;

    @Before
    public void setUp() {
        this.fTranslator = new TemplateTranslator();
    }

    @Test(expected=NullPointerException.class)
    public void testNullTemplate() throws Exception {
        this.fTranslator.translate(null);
    }

    @Test
    public void testEmptyTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)0L, (long)vars.length);
        Assert.assertEquals((Object)"", (Object)buffer.getString());
    }

    @Test
    public void testNoVarTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)0L, (long)vars.length);
        Assert.assertEquals((Object)"foo bar", (Object)buffer.getString());
    }

    @Test
    public void testSimpleTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var} bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"var", (Object)vars[0].getType());
    }

    @Test
    public void testMultiTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var} bar ${var} end");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar var end", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)2L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)12L, (long)vars[0].getOffsets()[1]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"var", (Object)vars[0].getType());
    }

    @Test
    public void testNonAsciiVarTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("System.out.println(${bl\u00f6d:var} + \" with element type \" + ${h\u00e4:elemType(bl\u00f6d)});");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"System.out.println(bl\u00f6d + \" with element type \" + h\u00e4);", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)2L, (long)vars.length);
        Assert.assertEquals((Object)"bl\u00f6d", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)19L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)4L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"bl\u00f6d", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"var", (Object)vars[0].getType());
        Assert.assertEquals((Object)"h\u00e4", (Object)vars[1].getName());
        Assert.assertEquals((long)1L, (long)vars[1].getOffsets().length);
        Assert.assertEquals((long)50L, (long)vars[1].getOffsets()[0]);
        Assert.assertEquals((long)2L, (long)vars[1].getLength());
        Assert.assertFalse((boolean)vars[1].isUnambiguous());
        Assert.assertEquals((Object)"h\u00e4", (Object)vars[1].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[1].getValues().length);
        Assert.assertEquals((Object)vars[1].getDefaultValue(), (Object)vars[1].getValues()[0]);
        Assert.assertEquals((Object)"elemType", (Object)vars[1].getType());
    }

    @Test
    public void testNumberAsIdentifier() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("${0:link(1,'2 ',3)}\\n${0}");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"0\\n0", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"0", (Object)vars[0].getName());
        Assert.assertEquals((long)2L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)0L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getOffsets()[1]);
        Assert.assertEquals((long)1L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"0", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"link", (Object)vars[0].getType());
        Assert.assertEquals(Arrays.asList("1", "2 ", "3"), (Object)vars[0].getVariableType().getParams());
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax1() throws Exception {
        this.fTranslator.translate("foo ${var");
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax2() throws Exception {
        this.fTranslator.translate("foo $");
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax3() throws Exception {
        this.fTranslator.translate("foo ${] } bar");
    }

    @Test
    public void testDollar() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo $$ bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)0L, (long)vars.length);
        Assert.assertEquals((Object)"foo $ bar", (Object)buffer.getString());
    }

    @Test
    public void testEmptyVariable() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${} bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo  bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)0L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"", (Object)vars[0].getType());
    }

    @Test
    public void testTypedTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var:type} bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)"type", (Object)vars[0].getType());
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
    }

    @Test
    public void testParameterizedTypeTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var:type(param)} bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"type", (Object)vars[0].getType());
        Assert.assertEquals(Collections.singletonList("param"), (Object)vars[0].getVariableType().getParams());
    }

    @Test
    public void testMultiParameterizedTypeTemplate1() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var:type(param)} bar ${var:type(param)} end");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar var end", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)2L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)12L, (long)vars[0].getOffsets()[1]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"type", (Object)vars[0].getType());
        Assert.assertEquals(Collections.singletonList("param"), (Object)vars[0].getVariableType().getParams());
    }

    @Test
    public void testMultiParameterizedTypeTemplate2() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${var:type(param)} bar ${var} end");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar var end", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)2L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)12L, (long)vars[0].getOffsets()[1]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"type", (Object)vars[0].getType());
        Assert.assertEquals(Collections.singletonList("param"), (Object)vars[0].getVariableType().getParams());
    }

    @Test(expected=TemplateException.class)
    public void testIllegallyParameterizedTypeTemplate1() throws Exception {
        this.fTranslator.translate("foo ${var:type(param)} bar ${var:type(other)} end");
    }

    @Test(expected=TemplateException.class)
    public void testIllegallyParameterizedTypeTemplate2() throws Exception {
        this.fTranslator.translate("foo ${var:type(param)} bar ${var:type} end");
    }

    @Test
    public void testParameterizedTypeTemplateWithWhitespace() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${ var : type ( param1 , param2 , param3 ) } bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"type", (Object)vars[0].getType());
        ArrayList<String> params = new ArrayList<String>(2);
        params.add("param1");
        params.add("param2");
        params.add("param3");
        Assert.assertEquals(params, (Object)vars[0].getVariableType().getParams());
    }

    @Test
    public void testQualifiedTypeTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${ var : qual.type ( qual.param1, qual.param2 ) } bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"qual.type", (Object)vars[0].getType());
        ArrayList<String> params = new ArrayList<String>(2);
        params.add("qual.param1");
        params.add("qual.param2");
        Assert.assertEquals(params, (Object)vars[0].getVariableType().getParams());
    }

    @Test
    public void testTextParameterTemplate() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("foo ${ var : qual.type ( 'a parameter 1', qual.param2, 'a parameter ''3' ) } bar");
        Assert.assertNull((Object)this.fTranslator.getErrorMessage());
        Assert.assertEquals((Object)"foo var bar", (Object)buffer.getString());
        TemplateVariable[] vars = buffer.getVariables();
        Assert.assertEquals((long)1L, (long)vars.length);
        Assert.assertEquals((Object)"var", (Object)vars[0].getName());
        Assert.assertEquals((long)1L, (long)vars[0].getOffsets().length);
        Assert.assertEquals((long)4L, (long)vars[0].getOffsets()[0]);
        Assert.assertEquals((long)3L, (long)vars[0].getLength());
        Assert.assertFalse((boolean)vars[0].isUnambiguous());
        Assert.assertEquals((Object)"var", (Object)vars[0].getDefaultValue());
        Assert.assertEquals((long)1L, (long)vars[0].getValues().length);
        Assert.assertEquals((Object)vars[0].getDefaultValue(), (Object)vars[0].getValues()[0]);
        Assert.assertEquals((Object)"qual.type", (Object)vars[0].getType());
        ArrayList<String> params = new ArrayList<String>(3);
        params.add("a parameter 1");
        params.add("qual.param2");
        params.add("a parameter '3");
        Assert.assertEquals(params, (Object)vars[0].getVariableType().getParams());
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax4() throws Exception {
        this.fTranslator.translate("foo ${var:} bar");
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax5() throws Exception {
        this.fTranslator.translate("foo ${var:type(} bar");
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax6() throws Exception {
        this.fTranslator.translate("foo ${var:type(] )} bar");
    }

    @Test(expected=TemplateException.class)
    public void testIllegalSyntax7() throws Exception {
        this.fTranslator.translate("foo ${var:type((} bar");
    }
}

