/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension5;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.tests.codemining.CodeMiningTestProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CodeMiningTest {
    private static String PROJECT_NAME = "test_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
    private static IProject project;

    @BeforeClass
    public static void beforeClass() throws Exception {
        CodeMiningTest.hideWelcomePage();
        CodeMiningTest.createProject(PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (project != null) {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @After
    public void after() {
        CodeMiningTest.closeAllEditors();
        this.drainEventQueue();
        CodeMiningTestProvider.provideContentMiningAtOffset = -1;
        CodeMiningTestProvider.provideHeaderMiningAtLine = -1;
        TestUtil.cleanUp();
    }

    private static void closeAllEditors() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                page.closeAllEditors(false);
                ++n4;
            }
            ++n2;
        }
    }

    private static void createProject(String projectName) throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(monitor);
                project.open(monitor);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testInlinedAnnotationSupportIsInLinesReturnsValidResultAfterDocumentChange() throws Exception {
        IFile file = project.getFile("test.testprojectionviewer");
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        String source = "first\nsecond\nthird\n";
        file.create((InputStream)new ByteArrayInputStream(source.getBytes("UTF-8")), true, (IProgressMonitor)new NullProgressMonitor());
        CodeMiningTestProvider.provideHeaderMiningAtLine = 2;
        CodeMiningTestProvider.lineHeaderMiningText = "    first line header\n    secone line header\n    third line header";
        int offset = source.indexOf("second") + "second".length();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.drainEventQueue();
        final ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextViewer.class);
        StyledText widget = viewer.getTextWidget();
        ProjectionAnnotationModel annotationModel = ((ProjectionViewer)viewer).getProjectionAnnotationModel();
        Annotation[] deletionsArray = new Annotation[]{};
        HashMap<ProjectionAnnotation, Position> additions = new HashMap<ProjectionAnnotation, Position>();
        ProjectionAnnotation annot = new ProjectionAnnotation();
        additions.put(annot, new Position(0, source.length()));
        annotationModel.modifyAnnotations(deletionsArray, additions, null);
        Assert.assertTrue((String)"Line header code mining above 3rd line not drawn", (boolean)this.waitForCondition(widget.getDisplay(), 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return CodeMiningTest.existsPixelWithNonBackgroundColorAtLine((ITextViewer)viewer, 2);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }));
        IDocument doc = viewer.getDocument();
        widget.setCaretOffset(offset);
        doc.replace(offset, 0, "\n        insert text");
        this.drainEventQueue();
        Assert.assertTrue((String)"Line header code mining above 4th line after inserting text not drawn", (boolean)this.waitForCondition(widget.getDisplay(), 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return CodeMiningTest.existsPixelWithNonBackgroundColorAtLine((ITextViewer)viewer, 3);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }));
    }

    @Test
    public void testCodeMiningOnEmptyLine() throws Exception {
        IFile file = project.getFile("test.txt");
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        String source = "first line\n\nthird line\n";
        file.create((InputStream)new ByteArrayInputStream(source.getBytes("UTF-8")), true, (IProgressMonitor)new NullProgressMonitor());
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.drainEventQueue();
        final ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextViewer.class);
        final StyledText widget = viewer.getTextWidget();
        Assert.assertTrue((String)"line content mining not available", (boolean)this.waitForCondition(widget.getDisplay(), 1000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (widget.getStyleRangeAtOffset(0) != null && widget.getStyleRangeAtOffset((int)0).metrics != null) {
                    return true;
                }
                return false;
            }
        }));
        this.drainEventQueue();
        CodeMiningTestProvider.provideHeaderMiningAtLine = 1;
        ((ISourceViewerExtension5)viewer).updateCodeMinings();
        Assert.assertTrue((String)"Code mining not drawn at empty line after calling updateCodeMinings", (boolean)this.waitForCondition(widget.getDisplay(), 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return CodeMiningTest.existsPixelWithNonBackgroundColorAtLine((ITextViewer)viewer, 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }));
    }

    @Test
    public void testCodeMiningAtEndOfLine() throws Exception {
        IFile file = project.getFile("test.txt");
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        String firstPart = "first line\nsecond line";
        String secondPart = "\nthird line\n";
        String source = firstPart + secondPart;
        file.create((InputStream)new ByteArrayInputStream(source.getBytes("UTF-8")), true, (IProgressMonitor)new NullProgressMonitor());
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.drainEventQueue();
        final ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextViewer.class);
        final StyledText widget = viewer.getTextWidget();
        Assert.assertTrue((String)"line content mining not available", (boolean)this.waitForCondition(widget.getDisplay(), 1000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (widget.getStyleRangeAtOffset(0) != null && widget.getStyleRangeAtOffset((int)0).metrics != null) {
                    return true;
                }
                return false;
            }
        }));
        this.drainEventQueue();
        CodeMiningTestProvider.provideContentMiningAtOffset = firstPart.length();
        ((ISourceViewerExtension5)viewer).updateCodeMinings();
        Assert.assertTrue((String)"Code mining not drawn at the end of second line after calling updateCodeMinings", (boolean)this.waitForCondition(widget.getDisplay(), 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return CodeMiningTest.existsPixelWithNonBackgroundColorAtEndOfLine((ITextViewer)viewer, 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }));
    }

    private void drainEventQueue() {
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    private static void hideWelcomePage() {
        IWorkbenchPage ap = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ap.hideView(ap.findViewReference("org.eclipse.ui.internal.introview"));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean existsPixelWithNonBackgroundColorAtLine(ITextViewer viewer, int line) throws BadLocationException {
        int lineLength;
        StyledText widget = viewer.getTextWidget();
        IDocument document = viewer.getDocument();
        String delim = document.getLineDelimiter(line);
        int delimLen = 0;
        if (delim != null) {
            delimLen = delim.length();
        }
        if ((lineLength = document.getLineLength(line) - delimLen) < 0) {
            lineLength = 0;
        }
        int verticalScroolBarWidth = viewer.getTextWidget().getVerticalBar().getThumbBounds().width;
        int lineOffset = document.getLineOffset(line);
        Rectangle lineBounds = widget.getTextBounds(lineOffset, lineOffset + lineLength);
        String lineStr = document.get(lineOffset, lineLength);
        Image image = new Image((Device)widget.getDisplay(), (gc, width, height) -> {}, widget.getSize().x, widget.getSize().y);
        try {
            block12: {
                int x;
                ImageData imageData;
                block11: {
                    GC gc2 = new GC((Drawable)widget);
                    gc2.copyArea(image, 0, 0);
                    Point textExtent = gc2.textExtent(lineStr);
                    if (lineBounds.height - textExtent.y > textExtent.y) {
                        lineBounds.height -= textExtent.y;
                    }
                    gc2.dispose();
                    imageData = image.getImageData();
                    x = lineBounds.x + 1;
                    if (!true) break block11;
                    if (x >= image.getBounds().width - verticalScroolBarWidth) return false;
                    if (x >= imageData.width - verticalScroolBarWidth) break block12;
                }
                do {
                    int y = lineBounds.y;
                    while (y < lineBounds.y + lineBounds.height) {
                        if (!imageData.palette.getRGB(imageData.getPixel(x, y)).equals((Object)widget.getBackground().getRGB())) {
                            return true;
                        }
                        ++y;
                    }
                    ++x;
                    if (x >= image.getBounds().width - verticalScroolBarWidth) return false;
                } while (x < imageData.width - verticalScroolBarWidth);
            }
            return false;
        }
        finally {
            image.dispose();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean existsPixelWithNonBackgroundColorAtEndOfLine(ITextViewer viewer, int line) throws BadLocationException {
        StyledText widget = viewer.getTextWidget();
        IDocument document = viewer.getDocument();
        int verticalScroolBarWidth = viewer.getTextWidget().getVerticalBar().getThumbBounds().width;
        int lineOffset = document.getLineOffset(line);
        String lineStr = document.get(lineOffset, document.getLineLength(line) - document.getLineDelimiter(line).length());
        Rectangle lineBounds = widget.getTextBounds(lineOffset, lineOffset);
        Image image = new Image((Device)widget.getDisplay(), (gc, width, height) -> {}, widget.getSize().x, widget.getSize().y);
        try {
            block9: {
                int x;
                ImageData imageData;
                block8: {
                    GC gc2 = new GC((Drawable)widget);
                    gc2.copyArea(image, 0, 0);
                    Point textExtent = gc2.textExtent(lineStr);
                    lineBounds.x += textExtent.x;
                    gc2.dispose();
                    imageData = image.getImageData();
                    x = lineBounds.x + 1;
                    if (!true) break block8;
                    if (x >= image.getBounds().width - verticalScroolBarWidth) return false;
                    if (x >= imageData.width - verticalScroolBarWidth) break block9;
                }
                do {
                    int y = lineBounds.y;
                    while (y < lineBounds.y + lineBounds.height) {
                        if (!imageData.palette.getRGB(imageData.getPixel(x, y)).equals((Object)widget.getBackground().getRGB())) {
                            return true;
                        }
                        ++y;
                    }
                    ++x;
                    if (x >= image.getBounds().width - verticalScroolBarWidth) return false;
                } while (x < imageData.width - verticalScroolBarWidth);
            }
            return false;
        }
        finally {
            image.dispose();
        }
    }

    private final boolean waitForCondition(Display display, long timeout, Callable<Boolean> condition) throws Exception {
        if (condition.call().booleanValue()) {
            return true;
        }
        if (timeout < 0L) {
            return false;
        }
        this.drainEventQueue();
        if (condition.call().booleanValue()) {
            return true;
        }
        if (timeout == 0L) {
            return false;
        }
        long start = System.currentTimeMillis();
        long diff = timeout;
        Boolean cond = false;
        do {
            if (display.sleep()) {
                this.drainEventQueue();
            }
            cond = condition.call();
            diff = System.currentTimeMillis() - start;
        } while (!cond.booleanValue() && diff < timeout);
        return cond;
    }
}

