/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMining;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;

public class CodeMiningTestProvider
extends AbstractCodeMiningProvider {
    public static int provideHeaderMiningAtLine = -1;
    public static int provideContentMiningAtOffset = -1;
    public static String lineHeaderMiningText;

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        try {
            ArrayList<Object> minings = new ArrayList<Object>();
            minings.add((Object)new StaticContentLineCodeMining(new Position(1, 1), "mining", (ICodeMiningProvider)this));
            if (provideHeaderMiningAtLine >= 0) {
                minings.add(new LineHeaderCodeMining(provideHeaderMiningAtLine, viewer.getDocument(), (ICodeMiningProvider)this){

                    public String getLabel() {
                        if (lineHeaderMiningText != null) {
                            return lineHeaderMiningText;
                        }
                        return "line header mining";
                    }
                });
            }
            if (provideContentMiningAtOffset >= 0) {
                minings.add(new AbstractCodeMining(new Position(provideContentMiningAtOffset, 1), (ICodeMiningProvider)this, null){

                    public String getLabel() {
                        return "Content mining";
                    }
                });
            }
            return CompletableFuture.completedFuture(minings);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final class StaticContentLineCodeMining
    extends LineContentCodeMining {
        public StaticContentLineCodeMining(Position position, String message, ICodeMiningProvider provider) {
            super(position, provider);
            this.setLabel(message);
        }

        public StaticContentLineCodeMining(int i, char c, ICodeMiningProvider repeatLettersCodeMiningProvider) {
            super(new Position(i, 1), repeatLettersCodeMiningProvider);
            this.setLabel(Character.toString(c));
        }

        public boolean isResolved() {
            return true;
        }
    }
}

