/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CaseActionTest {
    private static IProject project;
    private static IFile file;
    private AbstractTextEditor editor;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        file = project.getFile("foo.txt");
        file.create((InputStream)new ByteArrayInputStream("bar".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        TestUtil.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        this.editor = (AbstractTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
        this.editor.setFocus();
    }

    @After
    public void tearDown() throws Exception {
        this.editor.close(false);
        this.editor = null;
    }

    @Test
    public void testMultiSelectionCase() {
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        doc.set("foo bar foo");
        Object[] initialSelection = new IRegion[]{new Region(0, 3), new Region(8, 3)};
        this.editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(doc, (IRegion[])initialSelection));
        this.editor.getAction("UpperCase").run();
        Assert.assertEquals((Object)"FOO bar FOO", (Object)doc.get());
        Assert.assertArrayEquals((Object[])initialSelection, (Object[])((IMultiTextSelection)this.editor.getSelectionProvider().getSelection()).getRegions());
        doc.set("fo\u00df bar f\u00dfo bar \u00dfoo");
        this.editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(doc, new IRegion[]{new Region(0, 3), new Region(8, 3), new Region(16, 3)}));
        this.editor.getAction("UpperCase").run();
        Assert.assertEquals((Object)"FOSS bar FSSO bar SSOO", (Object)doc.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 4), new Region(9, 4), new Region(18, 4)}, (Object[])((IMultiTextSelection)this.editor.getSelectionProvider().getSelection()).getRegions());
    }
}

