/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ChainedPreferenceStoreTest {
    private final List<PropertyChangeEvent> fEvents = new ArrayList<PropertyChangeEvent>();
    private final PropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private static final String PROPERTY = "some.property";
    private static final String VALUE = "8";
    private static final String DEFAULT_VALUE = "4";
    private static final String DEFAULT_DEFAULT_VALUE = "";

    @After
    public void tearDown() {
        TestUtil.cleanUp();
    }

    @Test
    public void testChainedStore0() {
        PreferenceStore store1 = new PreferenceStore();
        PreferenceStore store2 = new PreferenceStore();
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{store1, store2});
        store2.setDefault(PROPERTY, DEFAULT_VALUE);
        chainedStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        store1.firePropertyChangeEvent(PROPERTY, (Object)VALUE, (Object)DEFAULT_DEFAULT_VALUE);
        chainedStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Assert.assertEquals((long)1L, (long)this.fEvents.size());
        PropertyChangeEvent event = this.fEvents.get(0);
        Assert.assertEquals((Object)chainedStore, (Object)event.getSource());
        Assert.assertEquals((Object)PROPERTY, (Object)event.getProperty());
        Assert.assertEquals((Object)VALUE, (Object)event.getOldValue());
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)event.getNewValue());
    }

    @Test
    public void testChainedStore1() {
        PreferenceStore store1 = new PreferenceStore();
        PreferenceStore store2 = new PreferenceStore();
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{store1, store2});
        chainedStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        store1.firePropertyChangeEvent(PROPERTY, (Object)VALUE, (Object)DEFAULT_DEFAULT_VALUE);
        chainedStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Assert.assertEquals((long)1L, (long)this.fEvents.size());
        PropertyChangeEvent event = this.fEvents.get(0);
        Assert.assertEquals((Object)store1, (Object)event.getSource());
        Assert.assertEquals((Object)PROPERTY, (Object)event.getProperty());
        Assert.assertEquals((Object)VALUE, (Object)event.getOldValue());
        Assert.assertEquals((Object)DEFAULT_DEFAULT_VALUE, (Object)event.getNewValue());
    }

    @Test
    public void testChainedStore2() {
        PreferenceStore store1 = new PreferenceStore();
        PreferenceStore store2 = new PreferenceStore();
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{store1, store2});
        store1.setValue(PROPERTY, VALUE);
        chainedStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        store1.firePropertyChangeEvent(PROPERTY, (Object)DEFAULT_VALUE, null);
        chainedStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Assert.assertEquals((long)1L, (long)this.fEvents.size());
        PropertyChangeEvent event = this.fEvents.get(0);
        Assert.assertEquals((Object)store1, (Object)event.getSource());
        Assert.assertEquals((Object)PROPERTY, (Object)event.getProperty());
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)event.getOldValue());
        Assert.assertEquals(null, (Object)event.getNewValue());
    }

    @Test
    public void testChainedStore3() {
        PreferenceStore store1 = new PreferenceStore();
        PreferenceStore store2 = new PreferenceStore();
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{store1, store2});
        store2.setDefault(PROPERTY, DEFAULT_VALUE);
        chainedStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        store1.firePropertyChangeEvent(PROPERTY, null, null);
        chainedStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Assert.assertEquals((long)1L, (long)this.fEvents.size());
        PropertyChangeEvent event = this.fEvents.get(0);
        Assert.assertEquals((Object)chainedStore, (Object)event.getSource());
        Assert.assertEquals((Object)PROPERTY, (Object)event.getProperty());
        Assert.assertEquals(null, (Object)event.getOldValue());
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)event.getNewValue());
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ChainedPreferenceStoreTest.this.fEvents.add(event);
        }
    }
}

