/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.File;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DocumentProviderRegistryTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private IFile file;

    @After
    public void tearDown() throws Exception {
        if (this.file != null) {
            ResourceHelper.delete((IProject)this.file.getProject());
        }
        TestUtil.cleanUp();
    }

    @Test
    public void testFindByExtensionInWorkspace() throws Exception {
        IFolder folder = ResourceHelper.createFolder((String)"DocumentProviderRegistryTestProject/test");
        this.file = ResourceHelper.createFile((IFolder)folder, (String)"file.testfile", (String)"");
        Assert.assertTrue((String)("File should exist: " + this.file.toString()), (boolean)this.file.exists());
        FileEditorInput editorInput = new FileEditorInput(this.file);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)editorInput);
        Assert.assertEquals((String)("Unexpected document provider found : " + provider.getClass().getName()), TestDocumentProvider.class, provider.getClass());
    }

    @Test
    public void testFindByExtensionNonWorkspace() throws Exception {
        File external = this.tmp.newFile("external.testfile");
        IFileStore store = EFS.getLocalFileSystem().getStore(IPath.fromOSString((String)external.getCanonicalPath()));
        FileStoreEditorInput editorInput = new FileStoreEditorInput(store);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)editorInput);
        Assert.assertEquals((String)("Unexpected document provider found : " + provider.getClass().getName()), TestDocumentProvider.class, provider.getClass());
    }

    public static class TestDocumentProvider
    extends TextFileDocumentProvider {
    }
}

