/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.FileDocumentProviderMock;
import org.eclipse.ui.editors.tests.LockJob;
import org.eclipse.ui.editors.tests.LockJob2;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class FileDocumentProviderTest {
    private File file;
    private AtomicBoolean stoppedByTest;
    private AtomicBoolean stopLockingFlag;
    private LockJob lockJob;
    private LockJob2 lockJob2;
    private FileDocumentProviderMock fileProvider;
    private FileSystemResourceManager fsManager;
    private IEditorPart editor;
    private IWorkbenchPage page;

    @Before
    public void setUp() throws Exception {
        FileDocumentProviderTest.closeIntro(PlatformUI.getWorkbench());
        IFolder folder = ResourceHelper.createFolder((String)"FileDocumentProviderTestProject/test");
        this.file = (File)ResourceHelper.createFile((IFolder)folder, (String)"file.txt", (String)"");
        Assert.assertTrue((boolean)this.file.exists());
        this.fsManager = this.file.getLocalManager();
        Assert.assertTrue((boolean)this.fsManager.fastIsSynchronized(this.file));
        this.stopLockingFlag = new AtomicBoolean(false);
        this.stoppedByTest = new AtomicBoolean(false);
        this.fileProvider = new FileDocumentProviderMock();
        this.lockJob = new LockJob("Locking workspace", (IResource)this.file, this.stopLockingFlag, this.stoppedByTest);
        this.lockJob2 = new LockJob2("Locking workspace", (IResource)this.file, this.stopLockingFlag, this.stoppedByTest);
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.page = workbench.getActiveWorkbenchWindow().getActivePage();
        this.editor = IDE.openEditor((IWorkbenchPage)this.page, (IFile)this.file);
        TestUtil.runEventLoop();
        IStatusLineManager statusLineManager = this.editor.getEditorSite().getActionBars().getStatusLineManager();
        IProgressMonitor progressMonitor = statusLineManager.getProgressMonitor();
        Assert.assertNotNull((Object)progressMonitor);
        Assert.assertFalse((boolean)(progressMonitor instanceof NullProgressMonitor));
        Assert.assertFalse((boolean)(progressMonitor instanceof EventLoopProgressMonitor));
        this.fileProvider.setProgressMonitor(progressMonitor);
        TestUtil.waitForJobs(500L, 5000L);
        Object[] jobs = Job.getJobManager().find(null);
        String jobsList = Arrays.toString(jobs);
        System.out.println("Still running jobs: " + jobsList);
        if (!Job.getJobManager().isIdle()) {
            Object[] objectArray = jobs = Job.getJobManager().find(null);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Object job = objectArray[n2];
                System.out.println("Going to cancel: " + job.getName() + " / " + String.valueOf(job));
                job.cancel();
                ++n2;
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.stopLockingFlag.set(true);
        this.lockJob.cancel();
        this.lockJob2.cancel();
        if (this.editor != null) {
            this.page.closeEditor(this.editor, false);
        }
        ResourceHelper.deleteProject((String)this.file.getProject().getName());
        TestUtil.runEventLoop();
        TestUtil.cleanUp();
    }

    @Test
    public void testRefreshFileWhileWorkspaceIsLocked1() throws Exception {
        Assert.assertNotNull((String)"Test must run in UI thread", (Object)Display.getCurrent());
        this.lockJob.schedule();
        this.makeSureResourceIsOutOfDate();
        Display.getCurrent().timerExec(500, () -> {
            this.stopLockingFlag.set(true);
            System.out.println("UI event dispatched, lock removed");
        });
        this.fileProvider.refreshFile((IFile)this.file);
        System.out.println("Busy wait terminated, UI thread is operable again!");
        Assert.assertFalse((String)"Test deadlocked while waiting on resource lock", (boolean)this.stoppedByTest.get());
        Assert.assertTrue((boolean)this.stopLockingFlag.get());
    }

    @Test
    public void testRefreshFileWhileWorkspaceIsLocked2() throws Exception {
        Assert.assertNotNull((String)"Test must run in UI thread", (Object)Display.getCurrent());
        this.lockJob.schedule();
        this.makeSureResourceIsOutOfDate();
        Display.getCurrent().timerExec(500, () -> {
            this.stopLockingFlag.set(true);
            System.out.println("UI event dispatched, lock removed");
        });
        this.fileProvider.refreshFile((IFile)this.file, this.fileProvider.getProgressMonitor());
        System.out.println("Busy wait terminated, UI thread is operable again!");
        Assert.assertFalse((String)"Test deadlocked while waiting on resource lock", (boolean)this.stoppedByTest.get());
        Assert.assertTrue((boolean)this.stopLockingFlag.get());
    }

    @Test
    public void testValidateStateForFileWhileWorkspaceIsLocked() throws Exception {
        Assert.assertNotNull((String)"Test must run in UI thread", (Object)Display.getCurrent());
        this.lockJob2.schedule();
        Thread.sleep(100L);
        Display.getCurrent().timerExec(600, () -> {
            this.stopLockingFlag.set(true);
            System.out.println("UI event dispatched, lock removed");
        });
        this.fileProvider.validateState(this.editor.getEditorInput(), this.editor.getSite().getShell());
        System.out.println("Busy wait terminated, UI thread is operable again!");
        Assert.assertFalse((String)"Test deadlocked while waiting on resource lock", (boolean)this.stoppedByTest.get());
        Assert.assertTrue((boolean)this.stopLockingFlag.get());
    }

    private void makeSureResourceIsOutOfDate() throws Exception {
        int count = 0;
        Files.setLastModifiedTime(this.file.getLocation().toFile().toPath(), FileTime.fromMillis(System.currentTimeMillis()));
        Thread.sleep(100L);
        while (this.fsManager.fastIsSynchronized(this.file) && count < 1000) {
            Files.setLastModifiedTime(this.file.getLocation().toFile().toPath(), FileTime.fromMillis(System.currentTimeMillis()));
            Thread.sleep(10L);
            ++count;
        }
        System.out.println("Managed to update file after " + count + " attempts");
        Assert.assertFalse((boolean)this.fsManager.fastIsSynchronized(this.file));
    }

    static void logError(String message, Exception ex) {
        String PLUGIN_ID = "org.eclipse.jface.text";
        ILog log = ILog.of((Bundle)Platform.getBundle((String)PLUGIN_ID));
        log.log((IStatus)new Status(4, PLUGIN_ID, 0, message, (Throwable)ex));
    }

    static void closeIntro(IWorkbench wb) {
        IIntroManager im;
        IIntroPart intro;
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window != null && (intro = (im = wb.getIntroManager()).getIntro()) != null) {
            im.closeIntro(intro);
        }
    }
}

