/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.findandreplace.HistoryStore;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FindNextActionTest {
    private static final String TEST_PROJECT_NAME = "TestProject";
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS_NAME = "org.eclipse.ui.texteditor.ConstructedEditorMessages";
    private static ResourceBundle bundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages");
    private AbstractTextEditor editor;
    private IProject project;
    private FindNextAction action;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
        this.project.create(null);
        this.project.open(null);
    }

    public void openEditorAndFindNextAction(String content, Direction direction) throws CoreException {
        IFile file = this.createTestFile(content);
        this.editor = FindNextActionTest.openEditor(file);
        this.action = new FindNextAction(bundleForConstructedKeys, "findNext", (IWorkbenchPart)this.editor, direction == Direction.FORWARD);
    }

    private IFile createTestFile(String content) throws CoreException {
        IFile file = this.project.getFile("file.txt");
        file.create(content.getBytes(), 1, null);
        file.setCharset(null, null);
        return file;
    }

    private static AbstractTextEditor openEditor(IFile file) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        MatcherAssert.assertThat((Object)editorPart, (Matcher)Matchers.instanceOf(AbstractTextEditor.class));
        return (AbstractTextEditor)editorPart;
    }

    @After
    public void tearDown() throws Exception {
        this.resetInitialSearchSettings();
        FindNextActionTest.closeEditor((IEditorPart)this.editor);
        this.editor = null;
        this.project.delete(true, null);
        this.project = null;
        TestUtil.cleanUp();
    }

    private void resetInitialSearchSettings() {
        IDialogSettings settings = this.getActionSettings();
        settings.put("isRegEx", false);
        settings.put("casesensitive", false);
        settings.put("wrap", true);
        settings.put("wholeword", false);
    }

    private static void closeEditor(IEditorPart editor) {
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        if (editor != null && (site = editor.getSite()) != null && (page = site.getPage()) != null) {
            page.closeEditor(editor, false);
        }
    }

    private void setEditorSelection(int offset, int length) {
        Document document = (Document)this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        TextSelection selection = new TextSelection((IDocument)document, offset, length);
        ISelectionProvider selectionProvider = this.editor.getSelectionProvider();
        selectionProvider.setSelection((ISelection)selection);
    }

    private void assertSelectionIs(int offset, int length) {
        Assert.assertEquals((long)offset, (long)this.getEditorSelection().getRegions()[0].getOffset());
        Assert.assertEquals((long)length, (long)this.getEditorSelection().getRegions()[0].getLength());
    }

    private TextSelection getEditorSelection() {
        ISelectionProvider selectionProvider = this.editor.getSelectionProvider();
        if (selectionProvider.getSelection() instanceof TextSelection) {
            return (TextSelection)selectionProvider.getSelection();
        }
        return null;
    }

    private IDialogSettings getActionSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindNextAction.class)).getDialogSettings();
        IDialogSettings fDialogSettings = settings.getSection(FindReplaceAction.class.getClass().getName());
        if (fDialogSettings == null) {
            fDialogSettings = settings.addNewSection(FindReplaceAction.class.getClass().getName());
        }
        return fDialogSettings;
    }

    @Test
    public void testFindNextForward() throws CoreException {
        this.openEditorAndFindNextAction("testtesttest", Direction.FORWARD);
        this.setEditorSelection(0, 4);
        this.action.run();
        this.assertSelectionIs(4, 4);
        this.action.run();
        this.assertSelectionIs(8, 4);
        this.action.run();
        this.assertSelectionIs(0, 4);
    }

    @Test
    public void testFindNextBackwards() throws CoreException {
        this.openEditorAndFindNextAction("testtesttest", Direction.BACKWARD);
        this.setEditorSelection(4, 4);
        this.action.run();
        this.assertSelectionIs(0, 4);
        this.action.run();
        this.assertSelectionIs(8, 4);
    }

    @Test
    public void testFindNextFromHistory() throws CoreException {
        this.openEditorAndFindNextAction("word-abcd-text", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        HistoryStore historyStore = new HistoryStore(settings, "findhistory", 15);
        historyStore.add("abcd");
        this.setEditorSelection(0, 0);
        this.action.run();
        this.assertSelectionIs(5, 4);
        this.setEditorSelection(3, 0);
        this.action.run();
        this.assertSelectionIs(5, 4);
    }

    @Test
    public void testFindNextStoresCorrectHistory() throws CoreException {
        this.openEditorAndFindNextAction("history", Direction.FORWARD);
        this.setEditorSelection(0, "history".length());
        this.action.run();
        IDialogSettings settings = this.getActionSettings();
        HistoryStore historyStore = new HistoryStore(settings, "findhistory", 15);
        MatcherAssert.assertThat((Object)historyStore.get(0), (Matcher)Matchers.is((Object)"history"));
    }

    @Test
    public void testFindNextWithRegExEscapedCorrectly() throws CoreException {
        this.openEditorAndFindNextAction("wo+rd-woord", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        this.setEditorSelection(0, 5);
        settings.put("isRegEx", true);
        this.action.run();
        this.assertSelectionIs(0, 5);
    }

    @Test
    public void testCaseSensitiveFindNext() throws CoreException {
        this.openEditorAndFindNextAction("wordWORD", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        settings.put("casesensitive", true);
        this.setEditorSelection(0, 4);
        this.action.run();
        this.assertSelectionIs(0, 4);
    }

    @Test
    public void testFindNextMultilineSelection() throws CoreException {
        this.openEditorAndFindNextAction("line\n\rnext\n\rnext\r\nline", Direction.FORWARD);
        this.setEditorSelection(0, 10);
        this.action.run();
        this.assertSelectionIs(18, 4);
    }

    @Test
    public void testFindNextNoWrap() throws CoreException {
        this.openEditorAndFindNextAction("wordword", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        settings.put("wrap", false);
        this.setEditorSelection(0, 4);
        this.action.run();
        this.assertSelectionIs(4, 4);
        this.action.run();
        this.assertSelectionIs(4, 4);
    }

    @Test
    public void testFindWholeWords() throws CoreException {
        this.openEditorAndFindNextAction("word longerword word", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        settings.put("wholeword", true);
        this.setEditorSelection(0, 4);
        this.action.run();
        this.assertSelectionIs(16, 4);
    }

    @Test
    public void testFindWholeWordsIsNotWord() throws CoreException {
        this.openEditorAndFindNextAction("w ord longerw ordinner w ord", Direction.FORWARD);
        IDialogSettings settings = this.getActionSettings();
        settings.put("wholeword", true);
        this.setEditorSelection(0, 5);
        this.action.run();
        this.assertSelectionIs(12, 5);
        this.action.run();
        this.assertSelectionIs(23, 5);
    }

    private static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

