/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LargeFileTest {
    private IFile fLargeFile;
    private IPreferenceStore preferenceStore;
    boolean initialWordWrap;

    @Before
    public void setUp() throws Exception {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
        IFolder folder = ResourceHelper.createFolder((String)"LargeFileTestProject/test/");
        this.fLargeFile = ResourceHelper.createFile((IFolder)folder, (String)"large.txt", (String)"");
        IFileStore store = EFS.getLocalFileSystem().getStore(this.fLargeFile.getLocationURI());
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(store.openOutputStream(0, null), StandardCharsets.UTF_8));){
            int i = 1;
            while (i <= 40000) {
                writer.write("This is line # " + i);
                writer.newLine();
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fLargeFile.refreshLocal(0, null);
        this.preferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        this.initialWordWrap = this.preferenceStore.getBoolean("wordwrap.enabled");
    }

    @After
    public void tearDown() throws Exception {
        this.fLargeFile.deleteMarkers("org.eclipse.core.resources.bookmark", true, 2);
        ResourceHelper.deleteProject((String)"LargeFileTestProject");
        this.fLargeFile = null;
        this.preferenceStore.setValue("wordwrap.enabled", this.initialWordWrap);
        TestUtil.cleanUp();
    }

    @Test
    public void openLargeFileWithAnnotation() throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        this.preferenceStore.setValue("wordwrap.enabled", true);
        long[] baseline = new long[1];
        int i = 0;
        while (i < 2) {
            baseline[0] = System.nanoTime();
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fLargeFile);
            display.asyncExec(() -> {
                lArray[0] = System.nanoTime() - baseline[0];
            });
            TestUtil.runEventLoop();
            Assert.assertTrue((String)"Expected a text editor", (boolean)(part instanceof ITextEditor));
            page.closeEditor(part, false);
            TestUtil.runEventLoop();
            ++i;
        }
        Map<String, Boolean> attributes = Map.of("location", "line 1", "message", "Just a test marker", "lineNumber", 1, "charStart", 8, "charEnd", 12, "userEditable", false);
        this.fLargeFile.createMarker("org.eclipse.core.resources.bookmark", attributes);
        TestUtil.runEventLoop();
        long[] withMarker = new long[]{System.nanoTime()};
        IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fLargeFile);
        display.asyncExec(() -> {
            lArray[0] = System.nanoTime() - withMarker[0];
        });
        TestUtil.runEventLoop();
        Assert.assertTrue((String)"Expected a text editor", (boolean)(part instanceof ITextEditor));
        page.closeEditor(part, false);
        TestUtil.runEventLoop();
        Assert.assertTrue((String)("Opening large file took too long: " + (float)withMarker[0] / 1000000.0f + "ms with marker vs. " + (float)baseline[0] / 1000000.0f + "ms without"), (withMarker[0] / 2L <= baseline[0] ? 1 : 0) != 0);
    }
}

