/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.editors.tests.FileDocumentProviderTest;

class LockJob2
extends Job {
    final IResource resource;
    AtomicBoolean stopFlag;
    AtomicBoolean stoppedByTest;

    public LockJob2(String name, IResource resource, AtomicBoolean stopFlag, AtomicBoolean stoppedByTest) {
        super(name);
        this.stopFlag = stopFlag;
        this.stoppedByTest = stoppedByTest;
        this.setUser(true);
        this.setSystem(true);
        this.resource = resource;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || LockJob2.class == family;
    }

    public IStatus run(IProgressMonitor monitor) {
        block11: {
            Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
            try {
                try {
                    workspace.prepareOperation(this.getRule(), monitor);
                    workspace.beginOperation(true);
                    this.run2();
                }
                catch (CoreException e) {
                    FileDocumentProviderTest.logError(e.getMessage(), (Exception)((Object)e));
                    try {
                        workspace.endOperation(this.getRule(), false);
                    }
                    catch (CoreException e2) {
                        FileDocumentProviderTest.logError(e2.getMessage(), (Exception)((Object)e2));
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    workspace.endOperation(this.getRule(), false);
                }
                catch (CoreException e) {
                    FileDocumentProviderTest.logError(e.getMessage(), (Exception)((Object)e));
                }
                throw throwable;
            }
            try {
                workspace.endOperation(this.getRule(), false);
            }
            catch (CoreException e) {
                FileDocumentProviderTest.logError(e.getMessage(), (Exception)((Object)e));
            }
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public IStatus run2() {
        long startTime = System.currentTimeMillis();
        int maxWaitTime = 300000;
        long stopTime = startTime + (long)maxWaitTime;
        System.out.println("Starting the busy wait while holding lock on: " + String.valueOf(this.resource.getFullPath()));
        try {
            while (!this.stopFlag.get()) {
                block9: {
                    try {
                        if (System.currentTimeMillis() <= stopTime) break block9;
                        FileDocumentProviderTest.logError("Timeout occurred while waiting on test to finish", new IllegalStateException());
                        this.stoppedByTest.set(true);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (InterruptedException e) {
                        this.stoppedByTest.set(true);
                        FileDocumentProviderTest.logError("Lock job was interrupted while waiting on test to finish", e);
                        e.printStackTrace();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        System.out.println("Lock task terminated");
                        return iStatus;
                    }
                }
                Thread.sleep(100L);
            }
        }
        finally {
            System.out.println("Lock task terminated");
        }
        return Status.OK_STATUS;
    }
}

