/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.ContributorFactorySimple;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class MarkerAnnotationOrderTest {
    IContributor pointContributor = null;
    Object masterToken = null;

    @Before
    public void setUp() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.pointContributor = ContributorFactorySimple.createContributor((Object)this);
        try {
            BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream("plugin.xml"));
            Field field = ExtensionRegistry.class.getDeclaredField("masterToken");
            field.setAccessible(true);
            this.masterToken = field.get(registry);
            registry.addContribution((InputStream)bis, this.pointContributor, true, null, null, this.masterToken);
        }
        catch (Exception ex) {
            Assert.fail((String)"update marker setup failed to execute");
            MarkerAnnotationOrderTest.log(ex);
        }
    }

    @After
    public void tearDown() throws Exception {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = extensions = registry.getExtensions(this.pointContributor);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if ("org.eclipse.ui.editors.markerUpdaters".equals(extension.getExtensionPointUniqueIdentifier())) {
                registry.removeExtension(extension, this.masterToken);
            }
            ++n2;
        }
        TestUtil.cleanUp();
    }

    @Test
    public void testDirectDependency() {
        ArrayList list = new ArrayList(2);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.editors");
        ILog log = ILog.of((Bundle)bundle);
        log.addLogListener((status, plugin) -> {
            boolean bl = list.add(status);
        });
        TestMarkerAnnotationModel t1 = new TestMarkerAnnotationModel();
        Position position = new Position(0);
        position.delete();
        IDocument d = null;
        try {
            t1.updateMarker(d, null, position);
        }
        catch (CoreException e) {
            Assert.fail((String)"update marker failed to execute");
            MarkerAnnotationOrderTest.log((Exception)((Object)e));
        }
        Assert.assertEquals((String)"Wrong number of messages", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Wrong Message for first status", (Object)"Marker Updater 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest2' and 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest1' depend on each other, 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest2' will run before 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest1'", (Object)((Status)list.get(0)).getMessage());
        Assert.assertEquals((String)"Wrong Message for second status", (Object)"Marker Updater 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest4' and 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest1' depend on each other, 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest4' will run before 'org.eclipse.ui.texteditor.BasicMarkerUpdaterTest1'", (Object)((Status)list.get(1)).getMessage());
    }

    private static void log(Exception ex) {
        String PLUGIN_ID = "org.eclipse.jface.text";
        ILog log = ILog.of((Bundle)Platform.getBundle((String)PLUGIN_ID));
        log.log((IStatus)new Status(4, PLUGIN_ID, 0, ex.getMessage(), (Throwable)ex));
    }

    public static class TestMarkerAnnotationModel
    extends AbstractMarkerAnnotationModel {
        protected IMarker[] retrieveMarkers() throws CoreException {
            return null;
        }

        protected void deleteMarkers(IMarker[] markers) throws CoreException {
        }

        protected void listenToMarkerChanges(boolean listen) {
        }

        protected boolean isAcceptable(IMarker marker) {
            return false;
        }
    }
}

