/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class StatusEditorTest {
    private IWorkbenchWindow window;
    private Display display;
    private IWorkbenchPage page;

    @Before
    public void before() throws WorkbenchException {
        this.window = PlatformUI.getWorkbench().openWorkbenchWindow(null);
        this.display = this.window.getShell().getDisplay();
        this.page = this.window.getActivePage();
        this.processEvents();
    }

    @After
    public void after() {
        this.window.close();
        this.page = null;
        this.processEvents();
        TestUtil.cleanUp();
    }

    @Test
    public void doNotThrowOnActivationInStale() throws Exception {
        IEditorPart editor1 = this.openNonExistentFile(this.page, new URI("file:/1.txt"));
        this.openNonExistentFile(this.page, new URI("file:/2.txt"));
        ILog log = ILog.of((Bundle)Platform.getBundle((String)"org.eclipse.e4.ui.workbench"));
        ArrayList logEvents = new ArrayList();
        ILogListener listener = (status, plugin) -> {
            boolean bl = logEvents.add(status.toString());
        };
        log.addLogListener(listener);
        CTabFolder folder = (CTabFolder)((PartSite)editor1.getSite()).getModel().getParent().getWidget();
        try {
            folder.setSelection(0);
            this.processEvents();
            folder.setSelection(1);
            this.processEvents();
        }
        finally {
            log.removeLogListener(listener);
        }
        if (!logEvents.isEmpty()) {
            Assert.assertEquals((String)"Unexpected errors logged", (Object)"", (Object)((Object)logEvents).toString());
        }
    }

    private void processEvents() {
        while (this.display.readAndDispatch()) {
        }
    }

    private IEditorPart openNonExistentFile(IWorkbenchPage page1, URI uri) throws Exception {
        FileStoreEditorInput input = new FileStoreEditorInput(EFS.getStore((URI)uri));
        TextEditor editor = (TextEditor)page1.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true);
        Method setMethod = AbstractTextEditor.class.getDeclaredMethod("setDocumentProvider", IDocumentProvider.class);
        setMethod.setAccessible(true);
        setMethod.invoke((Object)editor, new Object[]{new ErrorDocumentProvider(editor.getDocumentProvider())});
        editor.setInput((IEditorInput)input);
        this.processEvents();
        return editor;
    }

    private static class ErrorDocumentProvider
    extends ForwardingDocumentProvider {
        public ErrorDocumentProvider(IDocumentProvider parent) {
            super("", ignored -> {}, parent);
        }

        public IStatus getStatus(Object element) {
            return new Status(4, "org.eclipse.ui.workbench.texteditor.tests", 0, "This document provider always fails", null);
        }
    }
}

