/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;

public class TestUtil {
    public static void cleanUp() {
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
        boolean timedOut = TestUtil.waitForJobs(0L, TimeUnit.MINUTES.toMillis(3L));
        Assert.assertFalse((String)"Some Job did not terminate at the end of the test", (boolean)timedOut);
        TestUtil.runEventLoop();
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
    }

    public static void runEventLoop() {
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static boolean waitForJobs(long minTimeMs, long maxTimeMs) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            TestUtil.runEventLoop();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!Job.getJobManager().isIdle()) {
            if (System.currentTimeMillis() - start >= maxTimeMs) {
                return true;
            }
            TestUtil.runEventLoop();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }
}

