/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextMultiCaretNavigationTest {
    private static File file;
    private static AbstractTextEditor editor;
    private static StyledText widget;

    @Before
    public void setUpBeforeClass() throws IOException, PartInitException, CoreException {
        file = File.createTempFile(TextMultiCaretNavigationTest.class.getName(), ".txt");
        Files.write(file.toPath(), "  abc\n    1234\nxyz".getBytes(), new OpenOption[0]);
        editor = (AbstractTextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        widget = (StyledText)editor.getAdapter(Control.class);
    }

    @After
    public void tearDown() {
        editor.close(false);
        file.delete();
        TestUtil.cleanUp();
    }

    @Test
    public void testShiftHome() {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(document, new IRegion[]{new Region(5, 0), new Region(14, 0), new Region(18, 0)}));
        Assert.assertEquals((long)5L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        IMultiTextSelection selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(2, 3), new Region(10, 4), new Region(15, 3)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)2L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 5), new Region(6, 8), new Region(15, 3)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
    }

    @Test
    public void testShiftEnd() {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(document, new IRegion[]{new Region(0, 0), new Region(6, 0), new Region(15, 0)}));
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineEnd").run();
        IMultiTextSelection selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 5), new Region(6, 8), new Region(15, 3)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)5L, (long)widget.getCaretOffset());
    }

    @Test
    public void testShiftEndHomeHome() {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(document, new IRegion[]{new Region(0, 0), new Region(6, 0), new Region(15, 0)}));
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineEnd").run();
        IMultiTextSelection selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 5), new Region(6, 8), new Region(15, 3)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)5L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 2), new Region(6, 4), new Region(15, 0)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)2L, (long)widget.getCaretOffset());
        editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        selection = (IMultiTextSelection)editor.getSelectionProvider().getSelection();
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(6, 0), new Region(15, 0)}, (Object[])selection.getRegions());
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
    }
}

