/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextMultiCaretSelectionCommandsTest {
    private static final String MULTI_SELECTION_DOWN = "org.eclipse.ui.edit.text.select.selectMultiSelectionDown";
    private static final String ADD_ALL_MATCHES_TO_MULTI_SELECTION = "org.eclipse.ui.edit.text.select.addAllMatchesToMultiSelection";
    private static final String MULTI_SELECTION_UP = "org.eclipse.ui.edit.text.select.selectMultiSelectionUp";
    private static final String STOP_MULTI_SELECTION = "org.eclipse.ui.edit.text.select.stopMultiSelection";
    private static final String MULTI_CARET_DOWN = "org.eclipse.ui.edit.text.select.multiCaretDown";
    private static final String MULTI_CARET_UP = "org.eclipse.ui.edit.text.select.multiCaretUp";
    private static final String LINE_1 = "private static String a;\n";
    private static final String LINE_2 = "private static String b; // this is a little longer\n";
    private static final String LINE_3 = "\t\tprivate static String c;\n";
    private static final String LINE_4 = "private static String d";
    private static final int L1_LEN = "private static String a;\n".length();
    private static final int L2_LEN = "private static String b; // this is a little longer\n".length();
    private static final int L3_LEN = "\t\tprivate static String c;\n".length();
    private static final int L4_LEN = "private static String d".length();
    private static File file;
    private static AbstractTextEditor editor;
    private static StyledText widget;

    @Before
    public void setUpBeforeClass() throws IOException, PartInitException, CoreException {
        file = File.createTempFile(TextMultiCaretSelectionCommandsTest.class.getName(), ".txt");
        Files.write(file.toPath(), "private static String a;\nprivate static String b; // this is a little longer\n\t\tprivate static String c;\nprivate static String d".getBytes(), new OpenOption[0]);
        editor = (AbstractTextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        widget = (StyledText)editor.getAdapter(Control.class);
    }

    @After
    public void tearDown() {
        editor.close(false);
        file.delete();
        TestUtil.cleanUp();
    }

    @Test
    public void testMultiSelectionDown_withFirstIdentifierSelected_addsIdenticalIdentifiersToSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7)}, (Object[])this.getSelection());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7), new Region(L1_LEN + L2_LEN + 2, 7)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(7, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withSecondIdentifierSelectedIdentifier_addsNextOccurenceToSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(8, 6)});
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withSelectionInSecondRow_addsIdenticalIdentifierInThirdRowToSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + 8, 6)});
        Assert.assertEquals((long)(L1_LEN + 14), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)(L1_LEN + 14), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withTwoSelectionsAndAnchorBelow_reducesSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + 8, 6)});
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withTwoSelectionsAndAnchorAbove_extendsSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + 8, 6)});
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6)}, (Object[])this.getSelection());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6), new Region(L1_LEN + L2_LEN + L3_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretInFirstIdentifier_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(1, 0)});
        Assert.assertEquals((long)1L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretInSecondIdentifier_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(11, 0)});
        Assert.assertEquals((long)11L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretBetweenIdentifierCharAndNonIdentifierChar_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(23, 0)});
        Assert.assertEquals((long)23L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)23L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(22, 1)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretInSecondRow_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + 11, 0)});
        Assert.assertEquals((long)(L1_LEN + 11), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)(L1_LEN + 14), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretInIdentifierWithNoFollowingMatch_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + 11, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + 11), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + 14), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionDown_withCaretAtEndOfDocument_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + L4_LEN, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + L4_LEN), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + L4_LEN), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + L4_LEN - 1, 1)}, (Object[])this.getSelection());
    }

    @Test
    public void testAddAllMatches_withSingleSelection_selectsAllOccurences() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(ADD_ALL_MATCHES_TO_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7), new Region(L1_LEN + L2_LEN + 2, 7), new Region(L1_LEN + L2_LEN + L3_LEN, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testAddAllMatches_withDoubleSelectionOfSameText_selectsAllOccurences() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(ADD_ALL_MATCHES_TO_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7), new Region(L1_LEN + L2_LEN + 2, 7), new Region(L1_LEN + L2_LEN + L3_LEN, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testAddAllMatches_withDoubleSelectionOfDifferentTexts_doesNotChangeSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7), new Region(8, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(ADD_ALL_MATCHES_TO_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(8, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testAddAllMatches_withCaretInIdentifier_selectsAllOccurencesOfIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(2, 0)});
        Assert.assertEquals((long)2L, (long)widget.getCaretOffset());
        this.executeCommand(ADD_ALL_MATCHES_TO_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7), new Region(L1_LEN + L2_LEN + 2, 7), new Region(L1_LEN + L2_LEN + L3_LEN, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withCaretInIdentifier_selectsFullIdentifier() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + 11, 0)});
        Assert.assertEquals((long)(L1_LEN + 11), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertEquals((long)(L1_LEN + 8 + 6), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withSingleSelectionAndNoPreviousMatch_doesNothing() throws Exception {
        this.setSelection(new IRegion[]{new Region(8, 6)});
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withTwoSelections_removesSecondSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6)});
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withThreeSelections_removesThirdSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6)});
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertEquals((long)14L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withTwoSelectionsAndAnchorAbove_reducesSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(8, 6)});
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6)}, (Object[])this.getSelection());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiSelectionUp_withTwoSelectionsAndAnchorBelow_extendsSelection() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + 10, 6)});
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6)}, (Object[])this.getSelection());
        this.executeCommand(MULTI_SELECTION_UP);
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(8, 6), new Region(L1_LEN + 8, 6), new Region(L1_LEN + L2_LEN + 10, 6)}, (Object[])this.getSelection());
    }

    @Test
    public void testStopMultiSelection_withSingleSelection_doesNotChangeSelectionOrCaretOffset() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 7)}, (Object[])this.getSelection());
    }

    @Test
    public void testStopMultiSelection_withMultiSelection_revokesSelectionAndKeepsFirstCaretOffset() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(7, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testStopMultiSelection_withMultiSelectionAndCaretAtBeginning_revokesSelectionAndKeepsFirstCaretOffset() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(7, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testStopMultiSelection_withMultiSelectionAndCaretAfterLastSelection_revokesSelectionAndKeepsCaretOffset() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 7), new Region(L1_LEN, 7), new Region(L1_LEN + L2_LEN, 7)});
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_SELECTION_DOWN);
        this.executeCommand(MULTI_SELECTION_DOWN);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)7L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(7, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withCaret_addsCaretsInNextLines() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 0)});
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(L1_LEN, 0)}, (Object[])this.getSelection());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(L1_LEN, 0), new Region(L1_LEN + L2_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withTwoCaretsAndAnchorRegionBelow_removesFirstCaret() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN, 0)});
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(L1_LEN, 0)}, (Object[])this.getSelection());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withSingleSelection_addsSelectionInNextLine() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 3)});
        Assert.assertEquals((long)3L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)3L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 3), new Region(L1_LEN, 3)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)3L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(3, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withSingleCaretAtEndOfLongerLine_addsCaretAtEndOfNextLine() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)(L1_LEN + L2_LEN), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN, 0), new Region(L1_LEN + L2_LEN + L3_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + L2_LEN), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withSingleCaretInLineAboveLineWithTabs_addsCaretInNextLineRespectingTabs() throws Exception {
        widget.setTabs(4);
        this.setSelection(new IRegion[]{new Region(L1_LEN + 8, 0)});
        Assert.assertEquals((long)(L1_LEN + 8), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)(L1_LEN + 8), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 0), new Region(L1_LEN + L2_LEN + 2, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + 8), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withSingleCaretInLineWithTabs_addsCaretInNextLineRespectingTabs() throws Exception {
        widget.setTabs(4);
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0), new Region(L1_LEN + L2_LEN + L3_LEN + 8, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretDown_withSingleCaretAtEndOfText_doesNotChangeCaret() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + L4_LEN, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + L4_LEN), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + L4_LEN), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + L4_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + L4_LEN), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + L4_LEN, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withCaret_addsCaretsInPreviousLines() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN, 0), new Region(L1_LEN + L2_LEN, 0)}, (Object[])this.getSelection());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(L1_LEN, 0), new Region(L1_LEN + L2_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withTwoCaretsAndAnchorRegionAbove_removesLastCaret() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 0)});
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_DOWN);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(L1_LEN, 0)}, (Object[])this.getSelection());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withSingleSelection_addsSelectionInPreviousLine() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN, 3)});
        Assert.assertEquals((long)(L1_LEN + 3), (long)widget.getCaretOffset());
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)3L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 3), new Region(L1_LEN, 3)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)3L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(3, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withSingleCaretAtEndOfLongerLine_addsCaretAtEndOfPreviousLine() throws Exception {
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN, 0), new Region(L1_LEN + L2_LEN, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)L1_LEN, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withSingleCaretInLineBelowLineWithTabs_addsCaretInPreviousLineRespectingTabs() throws Exception {
        widget.setTabs(4);
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + L3_LEN + 8, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + L3_LEN + 8), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0), new Region(L1_LEN + L2_LEN + L3_LEN + 8, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withSingleCaretInLineWithTabs_addsCaretInPreviousLineRespectingTabs() throws Exception {
        widget.setTabs(4);
        this.setSelection(new IRegion[]{new Region(L1_LEN + L2_LEN + 2, 0)});
        Assert.assertEquals((long)(L1_LEN + L2_LEN + 2), (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)(L1_LEN + 8), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 0), new Region(L1_LEN + L2_LEN + 2, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)(L1_LEN + 8), (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(L1_LEN + 8, 0)}, (Object[])this.getSelection());
    }

    @Test
    public void testMultiCaretUp_withSingleCaretAtBeginningOfText_doesNotChangeCaret() throws Exception {
        this.setSelection(new IRegion[]{new Region(0, 0)});
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        widget.setSize(800, 500);
        this.executeCommand(MULTI_CARET_UP);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
        this.executeCommand(STOP_MULTI_SELECTION);
        Assert.assertEquals((long)0L, (long)widget.getCaretOffset());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0)}, (Object[])this.getSelection());
    }

    private void executeCommand(String commandId) throws Exception {
        Command command = ((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand(commandId);
        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, null, null));
    }

    private void setSelection(IRegion[] regions) {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        editor.getSelectionProvider().setSelection((ISelection)new MultiTextSelection(document, regions));
    }

    private IRegion[] getSelection() {
        return ((IMultiTextSelection)editor.getSelectionProvider().getSelection()).getRegions();
    }
}

