/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextNavigationTest {
    private File file;
    private AbstractTextEditor editor;
    private StyledText widget;
    private IDocument fDocument;

    @Before
    public void setUp() throws IOException, PartInitException, CoreException {
        this.file = File.createTempFile(TextNavigationTest.class.getName(), ".txt");
        Files.write(this.file.toPath(), "  abc".getBytes(), new OpenOption[0]);
        this.editor = (AbstractTextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)this.file.toURI()));
        this.fDocument = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        this.widget = (StyledText)this.editor.getAdapter(Control.class);
    }

    @After
    public void tearDown() {
        this.editor.close(false);
        this.file.delete();
        TestUtil.cleanUp();
    }

    @Test
    public void testHome() {
        IPreferenceStore preferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        boolean previousPrefValue = preferenceStore.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        preferenceStore.setValue("AbstractTextEditor.Navigation.SmartHomeEnd", false);
        this.fDocument.set("line1\nline2");
        this.editor.selectAndReveal(this.fDocument.getLength(), 0);
        this.editor.getAction("org.eclipse.ui.edit.text.goto.lineStart").run();
        try {
            Assert.assertEquals((long)6L, (long)((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset());
            this.editor.getAction("org.eclipse.ui.edit.text.goto.lineStart").run();
            Assert.assertEquals((long)6L, (long)((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset());
        }
        finally {
            preferenceStore.setValue("AbstractTextEditor.Navigation.SmartHomeEnd", previousPrefValue);
        }
    }

    @Test
    public void testShiftHome() {
        this.editor.selectAndReveal(5, 0);
        IAction action = this.editor.getAction("org.eclipse.ui.edit.text.select.lineStart");
        action.run();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)2L, (long)selection.getOffset());
        Assert.assertEquals((long)3L, (long)selection.getLength());
        Assert.assertEquals((long)2L, (long)this.widget.getCaretOffset());
        action.run();
        selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)5L, (long)selection.getLength());
        Assert.assertEquals((long)0L, (long)this.widget.getCaretOffset());
    }

    @Test
    public void testShiftEnd() {
        this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(0, 0));
        IAction action = this.editor.getAction("org.eclipse.ui.edit.text.select.lineEnd");
        action.run();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)5L, (long)selection.getLength());
        Assert.assertEquals((long)5L, (long)this.widget.getCaretOffset());
    }

    @Test
    public void testShiftEndMultipleLines() {
        this.fDocument.set("LINE 1\nLINE 2\n");
        this.editor.selectAndReveal(12, -7);
        this.editor.getAction("org.eclipse.ui.edit.text.select.lineEnd").run();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)6L, (long)selection.getOffset());
        Assert.assertEquals((long)6L, (long)selection.getLength());
        Assert.assertEquals((long)6L, (long)this.widget.getCaretOffset());
    }

    @Test
    public void testShiftEndHomeHome() {
        this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(0, 0));
        Assert.assertEquals((long)0L, (long)this.widget.getCaretOffset());
        this.editor.getAction("org.eclipse.ui.edit.text.select.lineEnd").run();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)5L, (long)selection.getLength());
        Assert.assertEquals((long)5L, (long)this.widget.getCaretOffset());
        this.editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)2L, (long)selection.getLength());
        Assert.assertEquals((long)2L, (long)this.widget.getCaretOffset());
        this.editor.getAction("org.eclipse.ui.edit.text.select.lineStart").run();
        selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)0L, (long)selection.getLength());
        Assert.assertEquals((long)0L, (long)this.widget.getCaretOffset());
    }

    @Test
    public void testEndHomeRevealCaret() {
        this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(0, 0));
        this.fDocument.set(IntStream.range(0, 2000).mapToObj(i -> "a").collect(Collectors.joining()));
        PlatformUI.getWorkbench().getIntroManager().closeIntro(PlatformUI.getWorkbench().getIntroManager().getIntro());
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)this.widget.getDisplay(), (long)2000L, () -> this.widget.isVisible()));
        int firstCharX = this.widget.getTextBounds((int)0, (int)0).x;
        Assert.assertTrue((firstCharX >= 0 && firstCharX <= this.widget.getClientArea().width ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.widget.getClientArea().x);
        this.editor.getAction("org.eclipse.ui.edit.text.goto.lineEnd").run();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        Assert.assertEquals((long)this.fDocument.getLength(), (long)selection.getOffset());
        int lastCharX = this.widget.getTextBounds((int)(this.fDocument.getLength() - 1), (int)(this.fDocument.getLength() - 1)).x;
        Assert.assertTrue((lastCharX >= 0 && lastCharX <= this.widget.getClientArea().width ? 1 : 0) != 0);
        this.editor.getAction("org.eclipse.ui.edit.text.goto.lineStart").run();
        firstCharX = this.widget.getTextBounds((int)0, (int)0).x;
        Assert.assertTrue((firstCharX >= 0 && firstCharX <= this.widget.getClientArea().width ? 1 : 0) != 0);
    }
}

