/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.internal.texteditor.stickyscroll.DefaultStickyLinesProvider;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLine;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultStickyLinesProviderTest {
    private Shell shell;
    private SourceViewer sourceViewer;
    private DefaultStickyLinesProvider stickyLinesProvider;
    private StyledText textWidget;
    private IStickyLinesProvider.StickyLinesProperties stickyLinesProperties;
    private IEditorPart editorPart;

    @Before
    public void setup() {
        this.shell = new Shell(Display.getDefault());
        this.sourceViewer = new SourceViewer((Composite)this.shell, null, 0);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.stickyLinesProvider = new DefaultStickyLinesProvider();
        this.textWidget = this.sourceViewer.getTextWidget();
        this.editorPart = (IEditorPart)Mockito.mock(IEditorPart.class);
        this.stickyLinesProperties = new IStickyLinesProvider.StickyLinesProperties(4, this.editorPart);
    }

    @After
    public void teardown() {
        TestUtil.cleanUp();
    }

    @Test
    public void testEmptySourceCode() {
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 0, this.stickyLinesProperties);
        MatcherAssert.assertThat((Object)stickyLines, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testSingleStickyLine() {
        String text = "line 1\n line 2<";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties);
        Assert.assertEquals((long)1L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((Object)"line 1", (Object)((IStickyLine)stickyLines.get(0)).getText());
    }

    @Test
    public void testLineUnderStickyLine() {
        String text = "line 1\n line 2<\n  line 3\n  line 4";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties);
        Assert.assertEquals((long)1L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
    }

    @Test
    public void testNewStickyRoot() {
        String text = "line 1\n line 2\nline 3\n line 4<";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 3, this.stickyLinesProperties);
        Assert.assertEquals((long)1L, (long)stickyLines.size());
        Assert.assertEquals((long)2L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
    }

    @Test
    public void testIgnoreEmptyLines() {
        String text = "line 1\n\n line 2\n\n  line 3<";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 4, this.stickyLinesProperties);
        Assert.assertEquals((long)2L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((long)2L, (long)((IStickyLine)stickyLines.get(1)).getLineNumber());
    }

    @Test
    public void testLinesWithTabs() {
        this.stickyLinesProperties = new IStickyLinesProvider.StickyLinesProperties(2, this.editorPart);
        String text = "line 1\n\tline 2\n\t\tline 3<";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 2, this.stickyLinesProperties);
        Assert.assertEquals((long)2L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((long)1L, (long)((IStickyLine)stickyLines.get(1)).getLineNumber());
    }

    @Test
    public void testStartAtEmptyLineWithNext() {
        String text = "line 1\n\n line 2\n\n  line 3";
        this.textWidget.setText(text);
        this.textWidget.setTopIndex(3);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 3, this.stickyLinesProperties);
        Assert.assertEquals((long)2L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((long)2L, (long)((IStickyLine)stickyLines.get(1)).getLineNumber());
    }

    @Test
    public void testStartAtEmptyLineWithPrevious() {
        String text = "line 1\n line 2\n  line 3\n\nline 4";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 3, this.stickyLinesProperties);
        Assert.assertEquals((long)2L, (long)stickyLines.size());
        Assert.assertEquals((long)0L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((long)1L, (long)((IStickyLine)stickyLines.get(1)).getLineNumber());
    }

    @Test
    public void testStickyLineWithSourceViewerLineMapping() {
        this.sourceViewer = new SourceViewerWithLineMapping((Composite)this.shell, null, 0);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.textWidget = this.sourceViewer.getTextWidget();
        String text = "line 1\n line 2<";
        this.textWidget.setText(text);
        List stickyLines = this.stickyLinesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 43, this.stickyLinesProperties);
        Assert.assertEquals((long)1L, (long)stickyLines.size());
        Assert.assertEquals((long)42L, (long)((IStickyLine)stickyLines.get(0)).getLineNumber());
        Assert.assertEquals((Object)"line 1", (Object)((IStickyLine)stickyLines.get(0)).getText());
    }

    private class SourceViewerWithLineMapping
    extends SourceViewer
    implements ITextViewerExtension5 {
        public SourceViewerWithLineMapping(Composite parent, IVerticalRuler ruler, int styles) {
            super(parent, ruler, styles);
        }

        public IRegion[] getCoveredModelRanges(IRegion modelRange) {
            return null;
        }

        public boolean exposeModelRange(IRegion modelRange) {
            return false;
        }

        public int widgetLine2ModelLine(int widgetLine) {
            return widgetLine + 42;
        }

        public int modelLine2WidgetLine(int widgetLine) {
            return widgetLine - 42;
        }
    }
}

