/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.internal.texteditor.stickyscroll.DefaultStickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLinesProviderDescriptor;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLinesProviderRegistry;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StickyLinesProviderRegistryTest {
    private StickyLinesProviderDescriptor stickyLinesProviderDescriptor;
    private StickyLinesProviderRegistry cut;
    private ISourceViewer viewer;
    private ITextEditor editor;

    @Before
    public void setup() {
        IConfigurationElement[] configurationElement = new IConfigurationElement[]{(IConfigurationElement)Mockito.mock(IConfigurationElement.class)};
        this.stickyLinesProviderDescriptor = (StickyLinesProviderDescriptor)Mockito.mock(StickyLinesProviderDescriptor.class);
        this.viewer = (ISourceViewer)Mockito.mock(ISourceViewer.class);
        this.editor = (ITextEditor)Mockito.mock(ITextEditor.class);
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)Mockito.mock(IExtensionRegistry.class);
        Mockito.when((Object)extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.editors", "stickyLinesProviders")).thenReturn((Object)configurationElement);
        this.cut = new StickyLinesProviderRegistry(extensionRegistry, e -> this.stickyLinesProviderDescriptor);
    }

    @After
    public void teardown() {
        TestUtil.cleanUp();
    }

    @Test
    public void testGetDefaultProviderIfNoMatch() {
        Mockito.when((Object)this.stickyLinesProviderDescriptor.matches(this.viewer, this.editor)).thenReturn((Object)false);
        IStickyLinesProvider provider = this.cut.getProvider(this.viewer, this.editor);
        MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.instanceOf(DefaultStickyLinesProvider.class));
    }

    @Test
    public void testGetProviderForMatch() {
        IStickyLinesProvider expProvider = (IStickyLinesProvider)Mockito.mock(IStickyLinesProvider.class);
        Mockito.when((Object)this.stickyLinesProviderDescriptor.matches(this.viewer, this.editor)).thenReturn((Object)true);
        Mockito.when((Object)this.stickyLinesProviderDescriptor.createStickyLinesProvider()).thenReturn((Object)expProvider);
        IStickyLinesProvider provider = this.cut.getProvider(this.viewer, this.editor);
        MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.is((Object)expProvider));
    }
}

