/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControl;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControlSettings;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLine;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StickyScrollingControlTest {
    private Shell shell;
    private SourceViewer sourceViewer;
    private Color lineNumberColor;
    private Color hoverColor;
    private Color backgroundColor;
    private Color separatorColor;
    private StickyScrollingControl stickyScrollingControl;
    private IVerticalRuler ruler;
    private StickyScrollingControlSettings settings;

    @Before
    public void setup() {
        this.shell = new Shell(Display.getDefault());
        this.shell.setSize(200, 200);
        this.shell.setLayout((Layout)new FillLayout());
        this.ruler = (IVerticalRuler)Mockito.mock(IVerticalRuler.class);
        this.sourceViewer = new SourceViewer((Composite)this.shell, this.ruler, 768);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 200);
        this.lineNumberColor = new Color(0, 0, 0);
        this.hoverColor = new Color(1, 1, 1);
        this.backgroundColor = new Color(2, 2, 2);
        this.separatorColor = new Color(3, 3, 3);
        this.settings = new StickyScrollingControlSettings(2, this.lineNumberColor, this.hoverColor, this.backgroundColor, this.separatorColor, true);
        this.stickyScrollingControl = new StickyScrollingControl((ISourceViewer)this.sourceViewer, this.ruler, this.settings, null);
    }

    @After
    public void teardown() {
        this.shell.dispose();
        this.stickyScrollingControl.dispose();
        this.lineNumberColor.dispose();
        this.hoverColor.dispose();
        this.backgroundColor.dispose();
        TestUtil.cleanUp();
    }

    @Test
    public void testShowStickyLineTexts() {
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        String expLineNumber = "10" + System.lineSeparator() + "20";
        Assert.assertEquals((Object)expLineNumber, (Object)stickyLineNumber.getText());
        StyledText stickyLineText = this.getStickyLineText();
        String expStickyLineText = "line 10" + System.lineSeparator() + "line 20";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    @Test
    public void testCorrectColorsApplied() {
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        Assert.assertEquals((Object)this.lineNumberColor, (Object)stickyLineNumber.getStyleRangeAtOffset((int)0).foreground);
        Assert.assertEquals((Object)this.backgroundColor, (Object)stickyLineNumber.getBackground());
        StyledText stickyLineText = this.getStickyLineText();
        Assert.assertEquals((Object)this.backgroundColor, (Object)stickyLineText.getBackground());
        Composite stickyLineSeparator = this.getStickyLineSeparator();
        Assert.assertEquals((Object)this.separatorColor, (Object)stickyLineSeparator.getBackground());
    }

    @Test
    public void testLimitStickyLinesCount() {
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        this.settings = new StickyScrollingControlSettings(1, this.lineNumberColor, this.hoverColor, this.backgroundColor, this.separatorColor, true);
        this.stickyScrollingControl.applySettings(this.settings);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        String expLineNumber = "10";
        Assert.assertEquals((Object)expLineNumber, (Object)stickyLineNumber.getText());
        StyledText stickyLineText = this.getStickyLineText();
        String expStickyLineText = "line 10";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    @Test
    public void testCopyStyleRanges() {
        StyleRange styleRangeLine1 = new StyleRange(0, 1, this.lineNumberColor, this.backgroundColor);
        StyleRange styleRangeLine2 = new StyleRange(0, 2, this.hoverColor, this.separatorColor);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 1", 0, new StyleRange[]{styleRangeLine1}), new StickyLineStub("line 2", 0, new StyleRange[]{styleRangeLine2}));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineText = this.getStickyLineText();
        StyleRange[] styleRanges = stickyLineText.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        Assert.assertEquals((long)0L, (long)styleRanges[0].start);
        Assert.assertEquals((long)1L, (long)styleRanges[0].length);
        Assert.assertEquals((Object)this.lineNumberColor, (Object)styleRanges[0].foreground);
        Assert.assertEquals((Object)this.backgroundColor, (Object)styleRanges[0].background);
        int startRangeLine2 = ((IStickyLine)stickyLines.get(0)).getText().length() + System.lineSeparator().length();
        Assert.assertEquals((long)startRangeLine2, (long)styleRanges[1].start);
        Assert.assertEquals((long)2L, (long)styleRanges[1].length);
        Assert.assertEquals((Object)this.hoverColor, (Object)styleRanges[1].foreground);
        Assert.assertEquals((Object)this.separatorColor, (Object)styleRanges[1].background);
    }

    @Test
    public void testCopyStyleRangesWithLimitedStickyLines() {
        this.settings = new StickyScrollingControlSettings(1, this.lineNumberColor, this.hoverColor, this.backgroundColor, this.separatorColor, true);
        this.stickyScrollingControl.applySettings(this.settings);
        StyleRange styleRangeLine1 = new StyleRange(0, 1, this.lineNumberColor, this.backgroundColor);
        StyleRange styleRangeLine2 = new StyleRange(0, 2, this.hoverColor, this.separatorColor);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 1", 0, new StyleRange[]{styleRangeLine1}), new StickyLineStub("line 2", 0, new StyleRange[]{styleRangeLine2}));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineText = this.getStickyLineText();
        StyleRange[] styleRanges = stickyLineText.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        Assert.assertEquals((long)0L, (long)styleRanges[0].start);
        Assert.assertEquals((long)1L, (long)styleRanges[0].length);
        Assert.assertEquals((Object)this.lineNumberColor, (Object)styleRanges[0].foreground);
        Assert.assertEquals((Object)this.backgroundColor, (Object)styleRanges[0].background);
    }

    @Test
    public void testWithoutVerticalRuler() {
        SourceViewer sourceViewerWithoutRuler = new SourceViewer((Composite)this.shell, null, 0);
        StickyScrollingControl stickyScrollingControlWithoutRuler = new StickyScrollingControl((ISourceViewer)sourceViewerWithoutRuler, new StickyScrollingControlSettings(5, this.lineNumberColor, this.hoverColor, this.backgroundColor, this.separatorColor, true));
        try {
            StyledText stickyLineNumber = this.getStickyLineNumber();
            Assert.assertFalse((boolean)stickyLineNumber.isVisible());
        }
        finally {
            sourceViewerWithoutRuler.getControl().dispose();
            stickyScrollingControlWithoutRuler.dispose();
        }
    }

    @Test
    public void testWithoutLineNumber() {
        Mockito.when((Object)this.ruler.getWidth()).thenReturn((Object)20);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        MatcherAssert.assertThat((Object)stickyLineNumber.getLeftMargin(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.settings = new StickyScrollingControlSettings(5, this.lineNumberColor, this.hoverColor, this.backgroundColor, this.separatorColor, false);
        this.stickyScrollingControl.applySettings(this.settings);
        stickyLineNumber = this.getStickyLineNumber();
        Assert.assertEquals((long)0L, (long)stickyLineNumber.getLeftMargin());
    }

    @Test
    public void testStyling() {
        Font font = new Font((Device)this.shell.getDisplay(), new FontData("Arial", 12, 1));
        this.sourceViewer.getTextWidget().setLineSpacing(10);
        this.sourceViewer.getTextWidget().setFont(font);
        this.sourceViewer.getTextWidget().setForeground(this.hoverColor);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 1", 0));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        Assert.assertEquals((long)10L, (long)stickyLineNumber.getLineSpacing());
        Assert.assertEquals((Object)font, (Object)stickyLineNumber.getFont());
        StyledText stickyLineText = this.getStickyLineText();
        Assert.assertEquals((long)10L, (long)stickyLineText.getLineSpacing());
        Assert.assertEquals((Object)font, (Object)stickyLineText.getFont());
        Assert.assertEquals((Object)this.hoverColor, (Object)stickyLineText.getForeground());
    }

    @Test
    public void testLayoutStickyLinesCanvasOnResize() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 200);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 1", 0));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        Rectangle boundsBeforeResize = stickyControlCanvas.getBounds();
        Assert.assertEquals((long)0L, (long)boundsBeforeResize.x);
        Assert.assertEquals((long)0L, (long)boundsBeforeResize.y);
        MatcherAssert.assertThat((Object)boundsBeforeResize.width, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)boundsBeforeResize.height, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.sourceViewer.getTextWidget().setBounds(0, 0, 150, 200);
        stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        Rectangle boundsAfterResize = stickyControlCanvas.getBounds();
        Assert.assertEquals((long)0L, (long)boundsAfterResize.x);
        Assert.assertEquals((long)0L, (long)boundsAfterResize.y);
        MatcherAssert.assertThat((Object)boundsAfterResize.width, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)boundsBeforeResize.width, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(boundsAfterResize.width)));
        Assert.assertEquals((long)boundsAfterResize.height, (long)boundsBeforeResize.height);
    }

    @Test
    public void testDontLayoutOutDatedStickyLinesOnResize() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 200);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 1", 1));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        Rectangle boundsBeforeResize = stickyControlCanvas.getBounds();
        this.sourceViewer.getTextWidget().setBounds(0, 0, 150, 200);
        stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        Rectangle boundsAfterResize = stickyControlCanvas.getBounds();
        Assert.assertEquals((Object)boundsAfterResize, (Object)boundsBeforeResize);
    }

    @Test
    public void testNavigateToStickyLine() {
        String text = "line 1\nline 2";
        this.sourceViewer.setInput((Object)new Document(text));
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 200);
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 2", 1));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        stickyControlCanvas.notifyListeners(3, new Event());
        Point selectedRange = this.sourceViewer.getSelectedRange();
        Assert.assertEquals((long)7L, (long)selectedRange.x);
        Assert.assertEquals((long)0L, (long)selectedRange.y);
    }

    @Test
    public void testVerticalScrollingIsDispatched() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 0);
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        String text = "line 1\nline 2";
        this.sourceViewer.setInput((Object)new Document(text));
        this.sourceViewer.getTextWidget().getVerticalBar().setIncrement(10);
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
        Event event = new Event();
        event.count = -1;
        stickyControlCanvas.notifyListeners(37, event);
        Assert.assertEquals((long)10L, (long)this.sourceViewer.getTextWidget().getTopPixel());
    }

    @Test
    public void testHorizontalScrollingIsDispatched() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 0, 200);
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        String text = "line 1\nline 2";
        this.sourceViewer.setInput((Object)new Document(text));
        this.sourceViewer.getTextWidget().getHorizontalBar().setIncrement(10);
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getHorizontalPixel());
        Event event = new Event();
        event.count = -1;
        stickyControlCanvas.notifyListeners(38, event);
        Assert.assertEquals((long)10L, (long)this.sourceViewer.getTextWidget().getHorizontalPixel());
    }

    @Test
    public void testLimitStickyLinesToTextWidgetHeight() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 200);
        this.sourceViewer.getTextWidget().setText("line1\nline2");
        List<StickyLineStub> stickyLines = List.of(new StickyLineStub("line 2", 1));
        this.stickyScrollingControl.setStickyLines(stickyLines);
        StyledText stickyLineText = this.getStickyLineText();
        Assert.assertEquals((Object)"line 2", (Object)stickyLineText.getText());
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 20);
        stickyLineText = this.getStickyLineText();
        Assert.assertEquals((Object)"", (Object)stickyLineText.getText());
    }

    @Test
    public void testListenForCaretAfterKeyDown() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 10);
        String text = "line 1\nline 2\nline 3\nline 4\nline 5\nline 6\nline 7\nline 8\nline 9";
        this.sourceViewer.setInput((Object)new Document(text));
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
        this.sourceViewer.getTextWidget().notifyListeners(1, new Event());
        this.sourceViewer.getTextWidget().setCaretOffset(42);
        this.drainDisplayEventQueue();
        MatcherAssert.assertThat((Object)this.sourceViewer.getTextWidget().getTopPixel(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testDontListenForCaretWithoutKeyDown() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 10);
        String text = "line 1\nline 2\nline 3\nline 4\nline 5\nline 6\nline 7\nline 8\nline 9";
        this.sourceViewer.setInput((Object)new Document(text));
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
        this.sourceViewer.getTextWidget().setCaretOffset(42);
        this.drainDisplayEventQueue();
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
    }

    @Test
    public void testDontScrollOnCaretAtDocumentEnd() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 10);
        String text = "line 1\nline 2\nline 3\nline 4\nline 5\nline 6\nline 7\nline 8\nline 9";
        this.sourceViewer.setInput((Object)new Document(text));
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
        this.sourceViewer.getTextWidget().notifyListeners(1, new Event());
        this.sourceViewer.getTextWidget().setCaretOffset(62);
        this.drainDisplayEventQueue();
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
    }

    @Test
    public void testDontScrollOnCaretWhenDocumentChangedBeforeExecution() {
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 10);
        String text = "line 1\nline 2\nline 3\nline 4\nline 5\nline 6\nline 7\nline 8\nline 9";
        this.sourceViewer.setInput((Object)new Document(text));
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
        this.sourceViewer.getTextWidget().notifyListeners(1, new Event());
        this.sourceViewer.getTextWidget().setCaretOffset(62);
        this.sourceViewer.setInput((Object)new Document("line"));
        this.drainDisplayEventQueue();
        Assert.assertEquals((long)0L, (long)this.sourceViewer.getTextWidget().getTopPixel());
    }

    private Canvas getStickyControlCanvas(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Canvas canvas;
            Control control = controlArray[n2];
            if (control instanceof Canvas && (canvas = (Canvas)control).getChildren().length == 3 && canvas.getChildren()[0] instanceof StyledText && canvas.getChildren()[1] instanceof StyledText && canvas.getChildren()[2] instanceof Composite) {
                return canvas;
            }
            if (control instanceof Composite) {
                Composite childComposite = (Composite)control;
                return this.getStickyControlCanvas(childComposite);
            }
            ++n2;
        }
        return null;
    }

    private StyledText getStickyLineNumber() {
        Canvas canvas = this.getStickyControlCanvas((Composite)this.shell);
        return (StyledText)canvas.getChildren()[0];
    }

    private StyledText getStickyLineText() {
        Canvas canvas = this.getStickyControlCanvas((Composite)this.shell);
        return (StyledText)canvas.getChildren()[1];
    }

    private Composite getStickyLineSeparator() {
        Canvas canvas = this.getStickyControlCanvas((Composite)this.shell);
        return (Composite)canvas.getChildren()[2];
    }

    private void drainDisplayEventQueue() {
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    private class StickyLineStub
    implements IStickyLine {
        private final String text;
        private final int lineNumber;
        private StyleRange[] styleRanges;

        public StickyLineStub(String text, int lineNumber) {
            this(text, lineNumber, null);
        }

        public StickyLineStub(String text, int lineNumber, StyleRange[] styleRanges) {
            this.text = text;
            this.lineNumber = lineNumber;
            this.styleRanges = styleRanges;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.text;
        }

        public StyleRange[] getStyleRanges() {
            return this.styleRanges;
        }
    }
}

