/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.List;
import java.util.StringJoiner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingHandler;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLine;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StickyScrollingHandlerTest {
    private Shell shell;
    private SourceViewer sourceViewer;
    private Color lineNumberColor;
    private Color hoverColor;
    private CompositeRuler ruler;
    private IPreferenceStore store;
    private IStickyLinesProvider linesProvider;
    private StickyScrollingHandler stickyScrollingHandler;
    private IStickyLinesProvider.StickyLinesProperties stickyLinesProperties;
    private StyledText textWidget;
    private IEditorPart editorPart;

    @Before
    public void setup() {
        this.shell = new Shell(Display.getDefault());
        this.shell.setBounds(0, 0, 200, 80);
        this.ruler = new CompositeRuler();
        this.sourceViewer = new SourceViewer((Composite)this.shell, (IVerticalRuler)this.ruler, 0);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.sourceViewer.getTextWidget().setBounds(0, 0, 200, 100);
        this.textWidget = this.sourceViewer.getTextWidget();
        this.textWidget.setText("first 1 \nline 2 \nline 3 \nline 4 \nline 5 \nline 6 \nline 7 \nline 8 \nline 9 \nline 10");
        this.textWidget.setTopIndex(1);
        this.editorPart = (IEditorPart)Mockito.mock(IEditorPart.class);
        this.lineNumberColor = new Color(0, 0, 0);
        this.hoverColor = new Color(1, 1, 1);
        this.store = this.createPreferenceStore();
        this.linesProvider = (IStickyLinesProvider)Mockito.mock(IStickyLinesProvider.class);
        this.stickyScrollingHandler = new StickyScrollingHandler((ISourceViewer)this.sourceViewer, (IVerticalRuler)this.ruler, this.store, this.linesProvider, this.editorPart);
        this.stickyLinesProperties = new IStickyLinesProvider.StickyLinesProperties(4, this.editorPart);
    }

    @After
    public void teardown() {
        this.shell.dispose();
        TestUtil.cleanUp();
    }

    @Test
    public void testShowStickyLines() {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        String expLineNumber = "10";
        Assert.assertEquals((Object)expLineNumber, (Object)stickyLineNumber.getText());
        StyledText stickyLineText = this.getStickyLineText();
        String expStickyLineText = "line 10";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    @Test
    public void testDontCalculateStickyLinesForFirstLine() {
        this.textWidget.setTopIndex(0);
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        Assert.assertEquals((Object)"", (Object)stickyLineNumber.getText());
        StyledText stickyLineText = this.getStickyLineText();
        Assert.assertEquals((Object)"", (Object)stickyLineText.getText());
        ((IStickyLinesProvider)Mockito.verify((Object)this.linesProvider, (VerificationMode)Mockito.never())).getStickyLines((ISourceViewer)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (IStickyLinesProvider.StickyLinesProperties)ArgumentMatchers.any());
    }

    @Test
    public void testUnistallStickyLines() {
        Canvas stickyControlCanvas = this.getStickyControlCanvas((Composite)this.shell);
        this.stickyScrollingHandler.uninstall();
        Assert.assertTrue((boolean)stickyControlCanvas.isDisposed());
    }

    @Test
    public void testPreferencesLoaded() {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineNumber = this.getStickyLineNumber();
        Assert.assertEquals((Object)this.lineNumberColor, (Object)stickyLineNumber.getStyleRangeAtOffset((int)0).foreground);
    }

    @Test
    public void testPreferencesUpdated() {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 2, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9), new StickyLineStub("line 20", 19)));
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineText = this.getStickyLineText();
        Object expStickyLineText = "line 10" + System.lineSeparator() + "line 20";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
        this.store.setValue("stickyScrollingMaximumCount", 1);
        expStickyLineText = "line 10";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    @Test
    public void testThrottledExecution() throws InterruptedException {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 10", 9)));
        this.stickyScrollingHandler.viewportChanged(100);
        Thread.sleep(10L);
        this.stickyScrollingHandler.viewportChanged(200);
        Thread.sleep(10L);
        this.stickyScrollingHandler.viewportChanged(300);
        Thread.sleep(10L);
        this.stickyScrollingHandler.viewportChanged(400);
        this.waitInUi(300);
        ((IStickyLinesProvider)Mockito.verify((Object)this.linesProvider, (VerificationMode)Mockito.atMost((int)3))).getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties);
        ((IStickyLinesProvider)Mockito.verify((Object)this.linesProvider, (VerificationMode)Mockito.atLeastOnce())).getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties);
    }

    @Test
    public void testRemoveStickyLines() {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 1", 0), new StickyLineStub("line 2", 1)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 2, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 3", 2)));
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineText = this.getStickyLineText();
        String expStickyLineText = "line 1";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    @Test
    public void testLineUnderStickyLine() {
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 1, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 1", 0)));
        Mockito.when((Object)this.linesProvider.getStickyLines((ISourceViewer)this.sourceViewer, 2, this.stickyLinesProperties)).thenReturn(List.of(new StickyLineStub("line 1", 0), new StickyLineStub("line 2", 1)));
        this.stickyScrollingHandler.viewportChanged(100);
        StyledText stickyLineText = this.getStickyLineText();
        String expStickyLineText = "line 1" + System.lineSeparator() + "line 2";
        Assert.assertEquals((Object)expStickyLineText, (Object)stickyLineText.getText());
    }

    private void waitInUi(int ms) throws InterruptedException {
        while (this.shell.getDisplay().readAndDispatch()) {
        }
        Thread.sleep(ms);
        while (this.shell.getDisplay().readAndDispatch()) {
        }
    }

    private IPreferenceStore createPreferenceStore() {
        this.store = new PreferenceStore();
        this.store.setValue("tabWidth", 4);
        this.store.setValue("stickyScrollingMaximumCount", 4);
        this.store.setValue("lineNumberColor", this.colorToString(this.lineNumberColor));
        this.store.setValue("currentLineColor", this.colorToString(this.hoverColor));
        this.store.setValue("lineNumberRuler", true);
        return this.store;
    }

    private StyledText getStickyLineNumber() {
        Canvas canvas = this.getStickyControlCanvas((Composite)this.shell);
        return (StyledText)canvas.getChildren()[0];
    }

    private StyledText getStickyLineText() {
        Canvas canvas = this.getStickyControlCanvas((Composite)this.shell);
        return (StyledText)canvas.getChildren()[1];
    }

    private Canvas getStickyControlCanvas(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Canvas canvas;
            Control control = controlArray[n2];
            if (control instanceof Canvas && (canvas = (Canvas)control).getChildren().length == 3 && canvas.getChildren()[0] instanceof StyledText && canvas.getChildren()[1] instanceof StyledText && canvas.getChildren()[2] instanceof Composite) {
                return canvas;
            }
            if (control instanceof Composite) {
                Composite childComposite = (Composite)control;
                return this.getStickyControlCanvas(childComposite);
            }
            ++n2;
        }
        return null;
    }

    private String colorToString(Color color) {
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(String.valueOf(color.getRed()));
        joiner.add(String.valueOf(color.getGreen()));
        joiner.add(String.valueOf(color.getBlue()));
        return joiner.toString();
    }

    private class StickyLineStub
    implements IStickyLine {
        private final String text;
        private final int lineNumber;

        public StickyLineStub(String text, int lineNumber) {
            this.text = text;
            this.lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.text;
        }

        public StyleRange[] getStyleRanges() {
            return null;
        }
    }
}

