/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor.stickyscroll;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.stickyscroll.StickyLine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StickyLineTest {
    private Shell shell;
    private StyledText textWidget;
    private Color color;
    private ISourceViewer sourceViewer;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.sourceViewer = new SourceViewer((Composite)this.shell, null, 0);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.textWidget = this.sourceViewer.getTextWidget();
        this.color = new Color(0, 0, 0);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
        this.color.dispose();
    }

    @Test
    public void testGetLineNumber() {
        StickyLine stickyLine = new StickyLine(1, this.sourceViewer);
        Assert.assertEquals((long)1L, (long)stickyLine.getLineNumber());
    }

    @Test
    public void testGetText() {
        this.textWidget.setText("line1\nline2\nline3");
        StickyLine stickyLine = new StickyLine(1, this.sourceViewer);
        Assert.assertEquals((Object)"line2", (Object)stickyLine.getText());
    }

    @Test
    public void testGetStyleRanges() {
        this.textWidget.setText("line1\nline2\nline3");
        this.textWidget.setStyleRange(new StyleRange(2, 1, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(6, 1, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(8, 2, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(15, 1, this.color, null));
        StickyLine stickyLine = new StickyLine(1, this.sourceViewer);
        StyleRange[] styleRanges = stickyLine.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        Assert.assertEquals((long)0L, (long)styleRanges[0].start);
        Assert.assertEquals((long)1L, (long)styleRanges[0].length);
        Assert.assertEquals((long)2L, (long)styleRanges[1].start);
        Assert.assertEquals((long)2L, (long)styleRanges[1].length);
    }

    @Test
    public void testGetStyleRangesIgnoresOutOfBoundLines() {
        this.textWidget.setText("line1\nline2\nline3");
        StickyLine stickyLineOutOfBound = new StickyLine(10, this.sourceViewer);
        Assert.assertNull((Object)stickyLineOutOfBound.getStyleRanges());
        stickyLineOutOfBound = new StickyLine(3, this.sourceViewer);
        Assert.assertNull((Object)stickyLineOutOfBound.getStyleRanges());
    }

    @Test
    public void WithSourceViewerLineMapping() {
        this.sourceViewer = new SourceViewerWithLineMapping((Composite)this.shell, null, 0);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.textWidget = this.sourceViewer.getTextWidget();
        this.textWidget.setText("line1\nline2\nline3");
        this.textWidget.setStyleRange(new StyleRange(2, 1, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(6, 1, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(8, 2, this.color, null));
        this.textWidget.setStyleRange(new StyleRange(15, 1, this.color, null));
        StickyLine stickyLine = new StickyLine(43, this.sourceViewer);
        StyleRange[] styleRanges = stickyLine.getStyleRanges();
        Assert.assertEquals((long)43L, (long)stickyLine.getLineNumber());
        Assert.assertEquals((Object)"line2", (Object)stickyLine.getText());
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        Assert.assertEquals((long)0L, (long)styleRanges[0].start);
        Assert.assertEquals((long)1L, (long)styleRanges[0].length);
        Assert.assertEquals((long)2L, (long)styleRanges[1].start);
        Assert.assertEquals((long)2L, (long)styleRanges[1].length);
    }

    private class SourceViewerWithLineMapping
    extends SourceViewer
    implements ITextViewerExtension5 {
        public SourceViewerWithLineMapping(Composite parent, IVerticalRuler ruler, int styles) {
            super(parent, ruler, styles);
        }

        public IRegion[] getCoveredModelRanges(IRegion modelRange) {
            return null;
        }

        public boolean exposeModelRange(IRegion modelRange) {
            return false;
        }

        public int widgetLine2ModelLine(int widgetLine) {
            return widgetLine + 42;
        }

        public int modelLine2WidgetLine(int widgetLine) {
            return widgetLine - 42;
        }
    }
}

