/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.views.properties.tabbed.article.views;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.examples.views.properties.tabbed.article.views.ButtonElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SizePropertySource
implements IPropertySource {
    protected ButtonElement element;
    public static String ID_WIDTH = "Width";
    public static String ID_HEIGHT = "Height";
    protected static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)ID_WIDTH, "width"), new TextPropertyDescriptor((Object)ID_HEIGHT, "height")};
    protected Point point = null;

    public SizePropertySource(ButtonElement m_element, Point point) {
        this.point = new Point(point.x, point.y);
        this.element = m_element;
    }

    protected void firePropertyChanged() {
        Button ctl = this.element.getControl();
        if (ctl == null) {
            return;
        }
        ctl.setSize(this.point);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propName) {
        if (ID_WIDTH.equals(propName)) {
            return Integer.toString(this.point.x);
        }
        if (ID_HEIGHT.equals(propName)) {
            return Integer.toString(this.point.y);
        }
        return null;
    }

    public Point getValue() {
        return new Point(this.point.x, this.point.y);
    }

    public boolean isPropertySet(Object propName) {
        return ID_WIDTH.equals(propName) || ID_HEIGHT.equals(propName);
    }

    public void resetPropertyValue(Object propName) {
    }

    public void setPropertyValue(Object propName, Object value) {
        int newInt;
        try {
            newInt = Integer.parseInt((String)value);
        }
        catch (NumberFormatException e) {
            newInt = -1;
        }
        if (newInt > 0) {
            if (ID_WIDTH.equals(propName)) {
                this.point.x = newInt;
            } else if (ID_HEIGHT.equals(propName)) {
                this.point.y = newInt;
            }
        }
        this.firePropertyChanged();
    }

    public String toString() {
        return this.point.toString();
    }
}

