/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.VersionIncompatibleException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.junit.Assert;
import org.osgi.util.tracker.ServiceTracker;

public class ImportExportTests
extends AbstractProvisioningTest {
    private P2ImportExport importexportService;
    private ServiceTracker<P2ImportExport, P2ImportExport> tracker;

    private List<IStatus> getChildren(IStatus s) {
        ArrayList<IStatus> rt = new ArrayList<IStatus>();
        if (s.isMultiStatus()) {
            IStatus[] iStatusArray = s.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                rt.addAll(this.getChildren(child));
                ++n2;
            }
        }
        rt.add(s);
        return rt;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tracker = new ServiceTracker(TestActivator.getContext(), P2ImportExport.class, null);
        this.tracker.open();
        this.importexportService = (P2ImportExport)this.tracker.getService();
        ImportExportTests.assertNotNull((String)"Fail to get ImportExport service", (Object)this.importexportService);
    }

    protected void tearDown() throws Exception {
        this.tracker.close();
        this.importexportService = null;
        super.tearDown();
    }

    public void testLoadP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/test.p2f");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = Files.newInputStream(p2fFile.toPath(), new OpenOption[0]);){
            List iuDetails = this.importexportService.importP2F(input);
            ImportExportTests.assertEquals((String)"Should load two features from the p2f file.", (int)2, (int)iuDetails.size());
            int counter = 0;
            for (IUDetail iu : iuDetails) {
                if ("org.polarion.eclipse.team.svn.connector.feature.group".equals(iu.getIU().getId())) {
                    ++counter;
                    ImportExportTests.assertEquals((String)"Should have two referred repository.", (int)2, (int)iu.getReferencedRepositories().size());
                    continue;
                }
                if (!"org.polarion.eclipse.team.svn.connector.svnkit16.feature.group".equals(iu.getIU().getId())) continue;
                ++counter;
                ImportExportTests.assertEquals((String)"Should have one referred repository", (int)1, (int)iu.getReferencedRepositories().size());
            }
            ImportExportTests.assertEquals((String)"Load unexpected content.", (int)2, (int)counter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testLoadUnknownP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/unknownformat.p2f");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = Files.newInputStream(p2fFile.toPath(), new OpenOption[0]);){
            List iuDetails = this.importexportService.importP2F(input);
            ImportExportTests.assertEquals((String)"Should not load any detail.", (int)0, (int)iuDetails.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testIncompatibleP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/incompatible.p2f");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = Files.newInputStream(p2fFile.toPath(), new OpenOption[0]);){
            Assert.assertThrows((String)"Didn't complain the given file is not supported by current version.", VersionIncompatibleException.class, () -> {
                List list = this.importexportService.importP2F(input);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testExportFeaturesInstalledFromLocal() throws ProvisionException, OperationCanceledException, IOException {
        File testFile = File.createTempFile("test", "p2f");
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportTests.getAgent().getService(IMetadataRepositoryManager.class);
            File localRepoFile = ImportExportTests.getTestData((String)"Error load data", (String)"testData/importexport/repo1");
            IMetadataRepository repo = metaManager.loadRepository(localRepoFile.toURI(), null);
            ImportExportTests.assertNotNull((String)"Fail to load local repo", (Object)repo);
            IInstallableUnit iu = ImportExportTests.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            Throwable throwable = null;
            Object var7_8 = null;
            try (OutputStream output = Files.newOutputStream(testFile.toPath(), new OpenOption[0]);){
                IStatus status = this.importexportService.exportP2F(output, new IInstallableUnit[]{iu}, false, null);
                ImportExportTests.assertFalse((String)"Not expected return result.", (boolean)status.isOK());
                ImportExportTests.assertTrue((String)"Should be a multiple status", (boolean)status.isMultiStatus());
                boolean hasFeaturesIgnored = false;
                for (IStatus s : this.getChildren(status)) {
                    if (s.getCode() != 1) continue;
                    hasFeaturesIgnored = true;
                }
                ImportExportTests.assertTrue((String)"Should have features ignored due to they're installed from local repository.", (boolean)hasFeaturesIgnored);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            testFile.delete();
        }
    }

    public void testAllowExportFeaturesInstalledFromLocal() throws ProvisionException, OperationCanceledException, IOException {
        File testFile = File.createTempFile("test", "p2f");
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportTests.getAgent().getService(IMetadataRepositoryManager.class);
            File localRepoFile = ImportExportTests.getTestData((String)"Error load data", (String)"testData/importexport/repo1");
            IMetadataRepository repo = metaManager.loadRepository(localRepoFile.toURI(), null);
            ImportExportTests.assertNotNull((String)"Fail to load local repo", (Object)repo);
            IInstallableUnit iu = ImportExportTests.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            Throwable throwable = null;
            Object var7_8 = null;
            try (OutputStream output = Files.newOutputStream(testFile.toPath(), new OpenOption[0]);){
                IStatus status = this.importexportService.exportP2F(output, new IInstallableUnit[]{iu}, true, null);
                ImportExportTests.assertTrue((boolean)status.isOK());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            testFile.delete();
        }
    }
}

