/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.actions;

import java.util.List;
import org.eclipse.equinox.internal.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.ui.actions.ProfileModificationActionTest;

public class UpdateActionTest
extends ProfileModificationActionTest {
    public void testLockedElements() {
        TestUpdateAction action = new TestUpdateAction(this.getTopLevelIUElementsWithLockedIU());
        UpdateActionTest.assertFalse((String)"Should not be enabled with locked elements", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testLockedIUs() {
        TestUpdateAction action = new TestUpdateAction(this.getTopLevelIUsWithLockedIU());
        UpdateActionTest.assertFalse((String)"Should not be enabled with locked ius", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testEmptySelection() {
        TestUpdateAction action = new TestUpdateAction(this.getEmptySelection());
        UpdateActionTest.assertFalse((String)"Should not be enabled with empty selection", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)0, (int)action.getSelectedIUs().size());
    }

    public void testTopLevelIUs() {
        TestUpdateAction action = new TestUpdateAction(this.getTopLevelIUs());
        UpdateActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testTopLevelElements() {
        TestUpdateAction action = new TestUpdateAction(this.getTopLevelIUElements());
        UpdateActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testNestedIUs() {
        TestUpdateAction action = new TestUpdateAction(this.getMixedIUs());
        UpdateActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testNestedElements() {
        TestUpdateAction action = new TestUpdateAction(this.getMixedIUElements());
        UpdateActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testMixedIUsAndNonIUs() {
        TestUpdateAction action = new TestUpdateAction(this.getMixedIUsAndNonIUs());
        UpdateActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testMixedIUsAndElements() {
        TestUpdateAction action = new TestUpdateAction(this.getMixedIUsAndElements());
        UpdateActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UpdateActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    class TestUpdateAction
    extends UpdateAction {
        TestUpdateAction(Object[] sel) {
            super(UpdateActionTest.this.getProvisioningUI(), UpdateActionTest.this.getSelectionProvider(sel), UpdateActionTest.this.profile.getProfileId(), true);
        }

        public List<IInstallableUnit> getSelectedIUs() {
            return super.getSelectedIUs();
        }
    }
}

