/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.sdk.RevertProfilePageWithCompare;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;
import org.eclipse.equinox.p2.ui.RevertProfilePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InstallationHistoryPageTest
extends AbstractProvisioningUITest {
    volatile int jobs;
    volatile int done;

    public void disabledtestDialogBackgroundFetch() {
        TestDialog dialog = new TestDialog();
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            try {
                Field viewerField = RevertProfilePage.class.getDeclaredField("configsViewer");
                viewerField.setAccessible(true);
                AbstractTableViewer viewer = (AbstractTableViewer)viewerField.get(dialog.page);
                ProvElementContentProvider provider = (ProvElementContentProvider)viewer.getContentProvider();
                Object input = viewer.getInput();
                Field jobField = ProvElementContentProvider.class.getDeclaredField("fetchJob");
                jobField.setAccessible(true);
                Field jobFamily = ProvElementContentProvider.class.getDeclaredField("fetchFamily");
                jobFamily.setAccessible(true);
                this.jobs = 0;
                this.done = 0;
                final Object family = jobFamily.get(provider);
                Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        if (e.getJob().belongsTo(family)) {
                            ++InstallationHistoryPageTest.this.done;
                            int status = e.getResult().getSeverity();
                            if (status != 8 && status != 0) {
                                InstallationHistoryPageTest.fail((String)("Fetch job failed unexpectedly " + e.getResult().getMessage()));
                            }
                        }
                    }
                });
                int i = 0;
                while (i < 5) {
                    provider.getElements(input);
                    Job job = (Job)jobField.get(provider);
                    if (job != null) {
                        ++this.jobs;
                    }
                    ++i;
                }
                Job.getJobManager().join(family, null);
                InstallationHistoryPageTest.assertTrue((String)"Something's wrong.  No fetch occurred", (this.jobs > 0 ? 1 : 0) != 0);
                InstallationHistoryPageTest.assertEquals((String)"Not all jobs finished as expected", (int)this.jobs, (int)this.done);
            }
            catch (Exception e) {
                InstallationHistoryPageTest.fail((String)"Failure during reflection", (Throwable)e);
                dialog.close();
            }
        }
        finally {
            dialog.close();
        }
    }

    public void testDialog() {
        TestDialog dialog = new TestDialog();
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    public void testDialogWithCompare() {
        TestDialog2 dialog = new TestDialog2();
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    class TestDialog
    extends Dialog {
        RevertProfilePage page;

        TestDialog() {
            super(ProvUI.getDefaultParentShell());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.page = new RevertProfilePage();
            this.page.createControl(composite);
            return composite;
        }
    }

    class TestDialog2
    extends Dialog {
        RevertProfilePageWithCompare page;

        TestDialog2() {
            super(ProvUI.getDefaultParentShell());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.page = new RevertProfilePageWithCompare();
            this.page.createControl(composite);
            return composite;
        }
    }
}

