/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;

public class UpdateWizardTest
extends WizardTest {
    private static final String SELECTION_PAGE = "IUSelectionPage";
    private static final String RESOLUTION_PAGE = "ResolutionPage";
    private static final String MAIN_IU = "MainIU";
    IInstallableUnit main;
    IInstallableUnit mainUpgrade1;
    IInstallableUnit mainUpgrade2;
    IInstallableUnit mainUpgradeWithLicense;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(MAIN_IU);
        iu.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iu.setSingleton(true);
        iu.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)MAIN_IU, (Version)iu.getVersion())});
        this.main = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        this.install(this.main, true, false);
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)MAIN_IU, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.mainUpgrade1 = UpdateWizardTest.createIU((String)MAIN_IU, (Version)Version.createOSGi((int)2, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)true, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        update = MetadataFactory.createUpdateDescriptor((String)MAIN_IU, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.mainUpgrade2 = UpdateWizardTest.createIU((String)MAIN_IU, (Version)Version.createOSGi((int)3, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)true, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(MAIN_IU);
        iu.setVersion(Version.createOSGi((int)4, (int)0, (int)0));
        iu.setSingleton(true);
        iu.setUpdateDescriptor(update);
        iu.setLicenses(new ILicense[]{new License(null, "Update Wizard Test License to Accept", null)});
        iu.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)MAIN_IU, (Version)iu.getVersion())});
        this.mainUpgradeWithLicense = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.main, this.mainUpgrade1, this.mainUpgrade2, this.mainUpgradeWithLicense});
    }

    public void testUpdateWizardResolved() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.main);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])op.getSelectedUpdates(), null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        ProfileModificationJob longOp = null;
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            UpdateWizardTest.assertTrue((boolean)page1.isPageComplete());
            ResolutionResultsWizardPage page2 = (ResolutionResultsWizardPage)wizard.getNextPage((IWizardPage)page1);
            dialog.showPage((IWizardPage)page2);
            UpdateWizardTest.assertTrue((boolean)page2.isPageComplete());
            longOp = this.getLongTestOperation();
            this.getProvisioningUI().schedule((ProvisioningJob)longOp, 1);
            UpdateWizardTest.assertTrue((boolean)page2.isPageComplete());
            wizard.recomputePlan((IRunnableContext)dialog);
            UpdateWizardTest.assertFalse((boolean)page2.isPageComplete());
            longOp.cancel();
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testUpdateWizardResolvedWithLicense() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.main);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])op.getSelectedUpdates(), null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            UpdateWizardTest.assertTrue((String)"1.0", (boolean)page1.isPageComplete());
            IWizardPage page = page1.getNextPage();
            dialog.showPage(page);
            UpdateWizardTest.assertFalse((String)"1.1", (boolean)wizard.canFinish());
            while (dialog.getShell().getDisplay().readAndDispatch()) {
            }
            Button finishButton = dialog.testGetButton(16);
            UpdateWizardTest.assertFalse((String)"1.2", (boolean)finishButton.isEnabled());
        }
        finally {
            dialog.getShell().close();
        }
    }

    public void testUpdateWizardResolvedError() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.main);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        op.setSelectedUpdates(op.getPossibleUpdates());
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])op.getSelectedUpdates(), null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            UpdateWizardTest.assertNotNull((String)"1.0", (Object)wizard.getStartingPage());
        }
        finally {
            dialog.getShell().close();
        }
    }

    public void testUpdateWizardResolvedSkipSelections() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.main);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])op.getSelectedUpdates(), null);
        wizard.setSkipSelectionsPage(true);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            UpdateWizardTest.assertNotNull((String)"1.0", (Object)wizard.getStartingPage());
            UpdateWizardTest.assertEquals((String)"1.1", (Object)wizard.getStartingPage(), (Object)wizard.getPage(RESOLUTION_PAGE));
        }
        finally {
            dialog.getShell().close();
        }
    }

    public void testBug277554MultipleVersions() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.main);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        op.resolveModal((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])op.getSelectedUpdates(), null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            UpdateWizardTest.assertTrue((String)"1.0", (boolean)page1.isPageComplete());
            UpdateWizardTest.assertEquals((String)"1.1", (int)1, (int)page1.getCheckedIUElements().length);
            ResolutionResultsWizardPage page2 = (ResolutionResultsWizardPage)wizard.getNextPage((IWizardPage)page1);
            dialog.showPage((IWizardPage)page2);
            UpdateWizardTest.assertEquals((String)"1.2", (int)1, (int)this.findTree(page2).getItemCount());
        }
        finally {
            dialog.getShell().close();
        }
    }
}

