/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;

public class InstallOperationTests
extends AbstractProvisioningUITest {
    public void testInstallerPlan() throws ProvisionException {
        URI uri = InstallOperationTests.getTestData((String)"InstallHandler", (String)"testData/installPlan").toURI();
        Set ius = InstallOperationTests.getMetadataRepositoryManager().loadRepository(uri, this.getMonitor()).query(QueryUtil.createIUQuery((String)"A"), this.getMonitor()).toSet();
        InstallOperationTests.assertEquals((String)"One IU", (int)1, (int)ius.size());
        InstallOperation op = new InstallOperation(this.getSession(), (Collection)ius);
        op.setProfileId("TestProfile");
        ProvisioningContext pc = new ProvisioningContext(InstallOperationTests.getAgent());
        pc.setArtifactRepositories(new URI[]{uri});
        pc.setMetadataRepositories(new URI[]{uri});
        op.setProvisioningContext(pc);
        InstallOperationTests.assertTrue((String)"Should resolve", (boolean)op.resolveModal(this.getMonitor()).isOK());
        InstallOperationTests.assertTrue((String)"Should install", (boolean)op.getProvisioningJob(null).runModal(this.getMonitor()).isOK());
        InstallOperationTests.assertFalse((String)"Action1 should have been installed", (boolean)this.getProfile("TestProfile").query(QueryUtil.createIUQuery((String)"Action1"), this.getMonitor()).isEmpty());
    }

    public void testDetectMissingRequirement() throws ProvisionException, OperationCanceledException {
        String testDataFileLocation = "testData/provisioningContextTests/";
        URI uriA = InstallOperationTests.getTestData((String)"A", (String)(testDataFileLocation + "A")).toURI();
        URI uriB = InstallOperationTests.getTestData((String)"B", (String)(testDataFileLocation + "B")).toURI();
        URI uriC = InstallOperationTests.getTestData((String)"C", (String)(testDataFileLocation + "C")).toURI();
        IMetadataRepository repoA = InstallOperationTests.getMetadataRepositoryManager().loadRepository(uriA, this.getMonitor());
        repoA.addReferences(Collections.singletonList(new RepositoryReference(uriA, null, 1, 1)));
        IMetadataRepository repoB = InstallOperationTests.getMetadataRepositoryManager().loadRepository(uriB, this.getMonitor());
        repoB.addReferences(Collections.singletonList(new RepositoryReference(uriB, null, 1, 1)));
        repoA.addReferences(Collections.singletonList(new RepositoryReference(repoB.getLocation(), null, 0, 1)));
        IMetadataRepository repoC = InstallOperationTests.getMetadataRepositoryManager().loadRepository(uriC, this.getMonitor());
        repoC.addReferences(Collections.singletonList(new RepositoryReference(uriC, null, 1, 1)));
        repoB.addReferences(Collections.singletonList(new RepositoryReference(repoC.getLocation(), null, 0, 1)));
        String id = "TestProfileIDForMissingRequirement";
        this.createProfile(id);
        ProvisioningContext context = new ProvisioningContext(InstallOperationTests.getAgent());
        context.setMetadataRepositories(new URI[]{repoA.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        IInstallableUnit[] units = (IInstallableUnit[])repoA.query(QueryUtil.createIUQuery((String)"A"), this.getMonitor()).toArray(IInstallableUnit.class);
        InstallOperationTests.assertTrue((String)"should find A in main repo", (units.length > 0 ? 1 : 0) != 0);
        InstallOperationTests.assertNull((String)"ProvisioningContext does not follow by default", (Object)context.getProperty("org.eclipse.equinox.p2.director.followRepositoryReferences"));
        InstallOperation op = new InstallOperation(this.getSession(), Collections.singleton(units[0]));
        op.setProvisioningContext(context);
        op.setProfileId(id);
        InstallOperationTests.assertTrue((String)"Should resolve", (boolean)op.resolveModal(this.getMonitor()).isOK());
        InstallOperationTests.assertNotNull((String)"Context was reset to follow", (Object)context.getProperty("org.eclipse.equinox.p2.director.followRepositoryReferences"));
        InstallOperationTests.getArtifactRepositoryManager().removeRepository(uriA);
        InstallOperationTests.getArtifactRepositoryManager().removeRepository(uriB);
        InstallOperationTests.getArtifactRepositoryManager().removeRepository(uriC);
        InstallOperationTests.getMetadataRepositoryManager().removeRepository(uriA);
        InstallOperationTests.getMetadataRepositoryManager().removeRepository(uriB);
        InstallOperationTests.getMetadataRepositoryManager().removeRepository(uriC);
    }

    public void testUpdateWithNamespaceChange() {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId("NewB");
        iud.setVersion(Version.create((String)"1.0.0"));
        String orExpression = "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && pc.name == 'B')";
        IExpression expr = ExpressionUtil.parse((String)orExpression);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        ArrayList<IMatchExpression> updateExpression = new ArrayList<IMatchExpression>();
        updateExpression.add(matchExpression);
        iud.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(updateExpression, (int)1, null, null));
        IInstallableUnit newIUB = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        IInstallableUnit installed = InstallOperationTests.createIU((String)"B");
        this.installAsRoots(this.profile, new IInstallableUnit[]{installed}, true, InstallOperationTests.createPlanner(), InstallOperationTests.createEngine());
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        ius.add(newIUB);
        InstallOperation op = new InstallOperation(this.getSession(), ius);
        op.setProfileId("TestProfile");
        IStatus resolutionStatus = op.resolveModal(this.getMonitor());
        InstallOperationTests.assertEquals((int)10001, (int)((MultiStatus)resolutionStatus).getChildren()[0].getCode());
        InstallOperationTests.assertEquals((int)10003, (int)((MultiStatus)((MultiStatus)resolutionStatus).getChildren()[0]).getChildren()[0].getCode());
    }
}

