/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.net.URI;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.LoadFailureAccumulator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LoadFailureAccumulatorTest
extends TestCase {
    public void testRecordFailureForSingleBadLocation() throws Exception {
        RepositoryTracker repositoryTracker = (RepositoryTracker)Mockito.mock(RepositoryTracker.class);
        LoadFailureAccumulator loadFailureAccumulator = new LoadFailureAccumulator(repositoryTracker);
        ProvisionException exception = this.buildProvisionExceptionWithCode(1006);
        URI invalidLocation = new URI("https://example.com/invalid");
        loadFailureAccumulator.recordLoadFailure(exception, invalidLocation);
        MatcherAssert.assertThat((Object)loadFailureAccumulator.allFailuresCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.hasSingleFailureCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.getLoadFailuresCausedByBadRepoLocation(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ((RepositoryTracker)Mockito.verify((Object)repositoryTracker, (VerificationMode)Mockito.times((int)1))).addNotFound(invalidLocation);
    }

    public void testRecordFailureForMultipleBadLocations() throws Exception {
        RepositoryTracker repositoryTracker = (RepositoryTracker)Mockito.mock(RepositoryTracker.class);
        LoadFailureAccumulator loadFailureAccumulator = new LoadFailureAccumulator(repositoryTracker);
        ProvisionException firstException = this.buildProvisionExceptionWithCode(1006);
        URI firstInvalidLocation = new URI("https://example.com/invalid");
        ProvisionException secondException = this.buildProvisionExceptionWithCode(1006);
        URI secondInvalidLocation = new URI("https://example.com/invalidTwo");
        loadFailureAccumulator.recordLoadFailure(firstException, firstInvalidLocation);
        loadFailureAccumulator.recordLoadFailure(secondException, secondInvalidLocation);
        MatcherAssert.assertThat((Object)loadFailureAccumulator.allFailuresCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.hasSingleFailureCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.getLoadFailuresCausedByBadRepoLocation(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{repositoryTracker});
        ((RepositoryTracker)inOrder.verify((Object)repositoryTracker, Mockito.times((int)1))).addNotFound(firstInvalidLocation);
        ((RepositoryTracker)inOrder.verify((Object)repositoryTracker, Mockito.times((int)1))).addNotFound(secondInvalidLocation);
    }

    public void testRecordFailureForMultipleBadLocationsAndOneFailureCausedBySomethingElse() throws Exception {
        RepositoryTracker repositoryTracker = (RepositoryTracker)Mockito.mock(RepositoryTracker.class);
        LoadFailureAccumulator loadFailureAccumulator = new LoadFailureAccumulator(repositoryTracker);
        ProvisionException firstException = this.buildProvisionExceptionWithCode(1006);
        URI firstInvalidLocation = new URI("https://example.com/invalid");
        ProvisionException secondException = this.buildProvisionExceptionWithCode(1006);
        URI secondInvalidLocation = new URI("https://example.com/invalidTwo");
        ProvisionException thirdException = this.buildProvisionExceptionWithCode(1007);
        URI thirdLocation = new URI("https://example.com/requiresAuthentication");
        loadFailureAccumulator.recordLoadFailure(firstException, firstInvalidLocation);
        loadFailureAccumulator.recordLoadFailure(secondException, secondInvalidLocation);
        loadFailureAccumulator.recordLoadFailure(thirdException, thirdLocation);
        MatcherAssert.assertThat((Object)loadFailureAccumulator.allFailuresCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.hasSingleFailureCausedByBadLocation(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)loadFailureAccumulator.getLoadFailuresCausedByBadRepoLocation(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{repositoryTracker});
        ((RepositoryTracker)inOrder.verify((Object)repositoryTracker, Mockito.times((int)1))).addNotFound(firstInvalidLocation);
        ((RepositoryTracker)inOrder.verify((Object)repositoryTracker, Mockito.times((int)1))).addNotFound(secondInvalidLocation);
        ((RepositoryTracker)Mockito.verify((Object)repositoryTracker, (VerificationMode)Mockito.never())).addNotFound(thirdLocation);
    }

    private ProvisionException buildProvisionExceptionWithCode(int code) {
        Status status = new Status(4, "pluginId", code, "message", (Throwable)new RuntimeException());
        return new ProvisionException((IStatus)status);
    }
}

