/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.LoadFailure;
import org.eclipse.equinox.p2.core.ProvisionException;

public class LoadFailureTest
extends TestCase {
    public void testFailureRepresentsBadRepositoryLocationForCodeInvalidRepositoryLocation() throws Exception {
        int code = 10100;
        ProvisionException provisionException = this.buildProvisionExceptionWithCode(code);
        boolean isBadLocation = LoadFailure.failureRepresentsBadRepositoryLocation((ProvisionException)provisionException);
        LoadFailureTest.assertTrue((boolean)isBadLocation);
    }

    public void testFailureRepresentsBadRepositoryLocationForCodeRepositoryInvalidLocation() throws Exception {
        int code = 1006;
        ProvisionException provisionException = this.buildProvisionExceptionWithCode(code);
        boolean isBadLocation = LoadFailure.failureRepresentsBadRepositoryLocation((ProvisionException)provisionException);
        LoadFailureTest.assertTrue((boolean)isBadLocation);
    }

    public void testFailureRepresentsBadRepositoryLocationForCodeRepositoryNotFound() throws Exception {
        int code = 1006;
        ProvisionException provisionException = this.buildProvisionExceptionWithCode(code);
        boolean isBadLocation = LoadFailure.failureRepresentsBadRepositoryLocation((ProvisionException)provisionException);
        LoadFailureTest.assertTrue((boolean)isBadLocation);
    }

    public void testFailureRepresentsBadRepositoryLocationForOtherCode() throws Exception {
        int code = 1002;
        ProvisionException provisionException = this.buildProvisionExceptionWithCode(code);
        boolean isBadLocation = LoadFailure.failureRepresentsBadRepositoryLocation((ProvisionException)provisionException);
        LoadFailureTest.assertFalse((boolean)isBadLocation);
    }

    private ProvisionException buildProvisionExceptionWithCode(int code) {
        Status status = new Status(4, "pluginId", code, "message", (Throwable)new RuntimeException());
        return new ProvisionException((IStatus)status);
    }
}

