/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.ColocatedRepositoryTracker;
import org.eclipse.equinox.internal.p2.ui.LocationNotFoundDialog;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LocationNotFoundDialogTest
extends AbstractProvisioningTest {
    public void testCorrectLocation() {
        String compositeRepo = "testData/bug338495/good.local";
        URI compositeRepoURI = LocationNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local").toURI();
        String childRepo = "testData/bug338495/good.local/one";
        URI childRepoOneURI = LocationNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local/one").toURI();
        ProvisioningUI provUI = (ProvisioningUI)Mockito.mock(ProvisioningUI.class);
        ProvisioningSession provisioningSession = (ProvisioningSession)Mockito.mock(ProvisioningSession.class);
        Mockito.when((Object)provUI.getSession()).thenReturn((Object)provisioningSession);
        ColocatedRepositoryTracker tracker = (ColocatedRepositoryTracker)Mockito.mock(ColocatedRepositoryTracker.class);
        URI location = compositeRepoURI;
        LocationNotFoundDialog dialog = new LocationNotFoundDialog((RepositoryTracker)tracker, provUI, location);
        URI correctedLocation = childRepoOneURI;
        String repositoryName = "repositoryName";
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{tracker, provUI});
        dialog.correctLocation(correctedLocation, repositoryName);
        ((ProvisioningUI)inOrder.verify((Object)provUI, Mockito.times((int)1))).signalRepositoryOperationStart();
        ((ColocatedRepositoryTracker)inOrder.verify((Object)tracker, Mockito.times((int)1))).removeRepositories(new URI[]{location}, provisioningSession);
        ((ColocatedRepositoryTracker)inOrder.verify((Object)tracker, Mockito.times((int)1))).addRepository(correctedLocation, repositoryName, provisioningSession);
        ((ProvisioningUI)inOrder.verify((Object)provUI, Mockito.times((int)1))).signalRepositoryOperationComplete(null, true);
    }

    public void testRemoveRepository() {
        String compositeRepo = "testData/bug338495/good.local";
        URI compositeRepoURI = LocationNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local").toURI();
        ProvisioningUI provUI = (ProvisioningUI)Mockito.mock(ProvisioningUI.class);
        ProvisioningSession provisioningSession = (ProvisioningSession)Mockito.mock(ProvisioningSession.class);
        Mockito.when((Object)provUI.getSession()).thenReturn((Object)provisioningSession);
        ColocatedRepositoryTracker tracker = (ColocatedRepositoryTracker)Mockito.mock(ColocatedRepositoryTracker.class);
        URI location = compositeRepoURI;
        LocationNotFoundDialog dialog = new LocationNotFoundDialog((RepositoryTracker)tracker, provUI, location);
        dialog.removeRepository();
        ((ColocatedRepositoryTracker)Mockito.verify((Object)tracker, (VerificationMode)Mockito.times((int)1))).removeRepositories(new URI[]{location}, provisioningSession);
    }

    public void testDisableRepository() {
        String compositeRepo = "testData/bug338495/good.local";
        URI compositeRepoURI = LocationNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local").toURI();
        String childRepo = "testData/bug338495/good.local/one";
        URI childRepoOneURI = LocationNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local/one").toURI();
        ProvisioningUI provUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provSession = provUI.getSession();
        ColocatedRepositoryTracker tracker = new ColocatedRepositoryTracker(provUI);
        tracker.addRepository(compositeRepoURI, "main", provSession);
        tracker.addRepository(childRepoOneURI, "child", provSession);
        URI location = compositeRepoURI;
        LocationNotFoundDialog dialog = new LocationNotFoundDialog((RepositoryTracker)tracker, provUI, location);
        dialog.disableRepository();
        MatcherAssert.assertThat((Object)ProvUI.getMetadataRepositoryManager((ProvisioningSession)provSession).isEnabled(location), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ProvUI.getArtifactRepositoryManager((ProvisioningSession)provSession).isEnabled(location), (Matcher)CoreMatchers.is((Object)false));
    }
}

