/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.ColocatedRepositoryTracker;
import org.eclipse.equinox.internal.p2.ui.MultipleLocationsNotFoundDialog;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MultipleLocationsNotFoundDialogTest
extends AbstractProvisioningTest {
    public void testRemoveRepositories() {
        String compositeRepo = "testData/bug338495/good.local";
        URI compositeRepoURI = MultipleLocationsNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local").toURI();
        ProvisioningUI provUI = (ProvisioningUI)Mockito.mock(ProvisioningUI.class);
        ProvisioningSession provisioningSession = (ProvisioningSession)Mockito.mock(ProvisioningSession.class);
        Mockito.when((Object)provUI.getSession()).thenReturn((Object)provisioningSession);
        ColocatedRepositoryTracker tracker = (ColocatedRepositoryTracker)Mockito.mock(ColocatedRepositoryTracker.class);
        URI firstLocation = compositeRepoURI;
        URI secondLocation = compositeRepoURI.resolve("/test2");
        URI[] locations = new URI[]{firstLocation, secondLocation};
        MultipleLocationsNotFoundDialog dialog = new MultipleLocationsNotFoundDialog((RepositoryTracker)tracker, provUI, locations);
        dialog.removeRepositories();
        ((ColocatedRepositoryTracker)Mockito.verify((Object)tracker, (VerificationMode)Mockito.times((int)1))).removeRepositories(locations, provisioningSession);
    }

    public void testDisableRepositories() {
        String compositeRepo = "testData/bug338495/good.local";
        URI compositeRepoURI = MultipleLocationsNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local").toURI();
        String childRepo = "testData/bug338495/good.local/one";
        URI childRepoOneURI = MultipleLocationsNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local/one").toURI();
        String childRepoTwo = "testData/bug338495/good.local/two";
        URI childRepoTwoURI = MultipleLocationsNotFoundDialogTest.getTestData((String)"composite repo", (String)"testData/bug338495/good.local/two").toURI();
        ProvisioningUI provUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provSession = provUI.getSession();
        ColocatedRepositoryTracker tracker = new ColocatedRepositoryTracker(provUI);
        tracker.addRepository(compositeRepoURI, "main", provSession);
        tracker.addRepository(childRepoOneURI, "child", provSession);
        tracker.addRepository(childRepoTwoURI, "child2", provSession);
        URI[] locations = new URI[]{childRepoOneURI, childRepoTwoURI};
        MultipleLocationsNotFoundDialog dialog = new MultipleLocationsNotFoundDialog((RepositoryTracker)tracker, provUI, locations);
        dialog.disableRepositories();
        MatcherAssert.assertThat((Object)ProvUI.getMetadataRepositoryManager((ProvisioningSession)provSession).isEnabled(childRepoOneURI), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ProvUI.getArtifactRepositoryManager((ProvisioningSession)provSession).isEnabled(childRepoOneURI), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ProvUI.getMetadataRepositoryManager((ProvisioningSession)provSession).isEnabled(childRepoTwoURI), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ProvUI.getArtifactRepositoryManager((ProvisioningSession)provSession).isEnabled(childRepoTwoURI), (Matcher)CoreMatchers.is((Object)false));
    }
}

