/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.ElementWrapper;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.junit.Assert;
import org.junit.Test;

public class QueryDescriptorTest {
    @Test
    public void testSimpleDescriptorWithWrapper() {
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), (IQuery)new SimpleMatchQuery(), new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        Assert.assertEquals((String)"1.0", (long)2L, (long)collection.size());
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("a")));
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
    }

    @Test
    public void testSimpleDescriptorWithoutWrapper() {
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), (IQuery)new SimpleMatchQuery(), new Collector());
        Collection collection = eqDescriptor.performQuery(null);
        Assert.assertEquals((String)"1.0", (long)2L, (long)collection.size());
        Assert.assertTrue((String)"1.1", (boolean)collection.contains("a"));
        Assert.assertTrue((String)"1.1", (boolean)collection.contains("b"));
    }

    @Test
    public void testCompoundDescriptorAND() {
        IQuery query = QueryUtil.createCompoundQuery((IQuery)new SimpleMatchQuery(), (IQuery)new SimpleMatchQuery2(), (boolean)true);
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), query, new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        Assert.assertEquals((String)"1.0", (long)1L, (long)collection.size());
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
    }

    @Test
    public void testCompoundDescriptorOR() {
        IQuery query = QueryUtil.createCompoundQuery((IQuery)new SimpleMatchQuery(), (IQuery)new SimpleMatchQuery2(), (boolean)false);
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), query, new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        Assert.assertEquals((String)"1.0", (long)3L, (long)collection.size());
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("a")));
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
        Assert.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("c")));
    }

    class SimpleMatchQuery
    extends MatchQuery<Object> {
        SimpleMatchQuery() {
        }

        @Deprecated
        public boolean isMatch(Object candidate) {
            return candidate == "a" || candidate == "b";
        }
    }

    class SimpleMatchQuery2
    extends MatchQuery<Object> {
        SimpleMatchQuery2() {
        }

        @Deprecated
        public boolean isMatch(Object candidate) {
            return candidate == "b" || candidate == "c";
        }
    }

    class SimpleQueryable
    implements IQueryable<String> {
        List<String> elements = Arrays.asList("a", "b", "c", "d", "e");

        SimpleQueryable() {
        }

        public IQueryResult<String> query(IQuery<String> query, IProgressMonitor monitor) {
            return query.perform(this.elements.iterator());
        }
    }

    class StringWrapper
    extends ElementWrapper {
        StringWrapper() {
        }

        protected Object wrap(Object item) {
            return new WrappedString((String)item);
        }
    }

    class WrappedString {
        String string;

        WrappedString(String string) {
            this.string = string;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WrappedString)) {
                return false;
            }
            WrappedString wrappedString = (WrappedString)obj;
            return this.string.equals(other.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }
}

