/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;

public class QueryProviderTests
extends AbstractProvisioningUITest {
    IInstallableUnit nestedCategory;
    IInstallableUnit a;
    IInstallableUnit b;
    IInstallableUnit c;
    static final String CAT = "Category";
    static final String NESTED = "NestedCategory";
    static final String A = "A";
    static final String B = "B";
    static final String C = "C";
    IMetadataRepository testRepo;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> categoryProperties = new HashMap<String, String>();
        categoryProperties.put("org.eclipse.equinox.p2.type.category", "true");
        HashMap<String, String> groupProperties = new HashMap<String, String>();
        groupProperties.put("org.eclipse.equinox.p2.type.group", "true");
        IInstallableUnit cat = QueryProviderTests.createIU((String)CAT, (Version)Version.create((String)"1.0.0"), (IRequirement[])QueryProviderTests.createRequiredCapabilities((String)"org.eclipse.equinox.p2.iu", (String)NESTED), categoryProperties, (boolean)true);
        this.nestedCategory = QueryProviderTests.createIU((String)NESTED, (Version)Version.create((String)"1.0.0"), (IRequirement[])QueryProviderTests.createRequiredCapabilities((String)"org.eclipse.equinox.p2.iu", (String)A), categoryProperties, (boolean)true);
        this.a = QueryProviderTests.createIU((String)A, (Version)Version.create((String)"1.0.0"), (IRequirement[])QueryProviderTests.createRequiredCapabilities((String)"org.eclipse.equinox.p2.iu", (String)B), groupProperties, (boolean)true);
        this.b = QueryProviderTests.createIU((String)B, (Version)Version.create((String)"1.0.0"), (IRequirement[])QueryProviderTests.createRequiredCapabilities((String)"org.eclipse.equinox.p2.iu", (String)C), groupProperties, (boolean)true);
        this.c = QueryProviderTests.createIU((String)C, (Version)Version.create((String)"1.0.0"), (IRequirement[])NO_REQUIRES, (Map)NO_PROPERTIES, (boolean)true);
        this.testRepo = this.createTestMetdataRepository(new IInstallableUnit[]{cat, this.nestedCategory, this.a, this.b, this.c});
    }

    public void testNestedCategories() {
        MetadataRepositoryElement element = new MetadataRepositoryElement(null, this.testRepo.getLocation(), true);
        Object[] children = element.getChildren((Object)element);
        QueryProviderTests.assertEquals((String)"1.1", (int)1, (int)children.length);
        QueryProviderTests.assertTrue((String)"1.2", (boolean)(children[0] instanceof CategoryElement));
        CategoryElement cat = (CategoryElement)children[0];
        children = cat.getChildren((Object)cat);
        boolean foundNestedCategory = false;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object children1 = objectArray[n2];
            if (children1 instanceof CategoryElement && ((CategoryElement)children1).getIU().equals((Object)this.nestedCategory)) {
                foundNestedCategory = true;
                break;
            }
            ++n2;
        }
        QueryProviderTests.assertTrue((String)"1.3", (boolean)foundNestedCategory);
    }

    public void testInstallDrilldown() {
        IUElementListRoot root = new IUElementListRoot();
        AvailableIUElement element = new AvailableIUElement((Object)root, this.a, "TestProfile", this.getPolicy().getShowDrilldownRequirements());
        root.setChildren(new Object[]{element});
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a);
        InstallOperation op = new InstallOperation(this.getSession(), iusInvolved);
        op.setProfileId("TestProfile");
        op.resolveModal(this.getMonitor());
        IQueryable queryable = op.getProvisioningPlan().getAdditions();
        element.setQueryable(queryable);
        Object[] children = element.getChildren((Object)element);
        QueryProviderTests.assertEquals((String)"1.1", (int)1, (int)children.length);
    }
}

