/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.examples;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExampleRefactoring
extends Refactoring {
    private IFile fFile;
    private String fOldText;
    private String fNewText;
    private Change fChange;

    public ExampleRefactoring(IFile file) {
        this.fFile = file;
        this.fChange = null;
        this.fOldText = null;
        this.fNewText = null;
    }

    public String getName() {
        return "Make replaces";
    }

    public void setNewText(String text) {
        this.fNewText = text;
    }

    public void setOldText(String text) {
        this.fOldText = text;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fFile == null || !this.fFile.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)"File does not exist");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fOldText == null || this.fOldText.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)"Old text must be set and not empty");
        }
        if (this.fNewText == null || this.fNewText.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)"New text must be set and not empty");
        }
        TextFileChange change = new TextFileChange(this.getName(), this.fFile);
        change.setEdit((TextEdit)new MultiTextEdit());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, null);
        try {
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            String content = textFileBuffer.getDocument().get();
            int i = 0;
            int count = 1;
            while (i < content.length()) {
                int offset = content.indexOf(this.fOldText, i);
                if (offset == -1) break;
                ReplaceEdit replaceEdit = new ReplaceEdit(offset, this.fOldText.length(), this.fNewText);
                change.addEdit((TextEdit)replaceEdit);
                change.addTextEditGroup(new TextEditGroup("Change " + count++, (TextEdit)replaceEdit));
                i = offset + this.fOldText.length();
            }
            if (count == 1) {
                this.fChange = new NullChange(this.getName());
                RefactoringStatus refactoringStatus = RefactoringStatus.createErrorStatus((String)("No matches found for '" + this.fOldText + "'"));
                return refactoringStatus;
            }
            this.fChange = change;
        }
        finally {
            manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, null);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }
}

