/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCheatSheetManagerEvents {
    private CheatSheetElement element;
    private CheatSheetManager manager;
    private int handler1Calls;
    private int handler2Calls;

    @BeforeEach
    public void setUp() throws Exception {
        this.element = new CheatSheetElement("Name");
        this.manager = new CheatSheetManager(this.element);
        this.handler1Calls = 0;
        this.handler2Calls = 0;
    }

    @Test
    public void testNoHandler() {
        this.manager.fireEvent(2);
    }

    @Test
    public void testOneHandler() {
        this.manager.addListener((CheatSheetListener)new Handler1());
        this.manager.fireEvent(2);
        Assertions.assertEquals((int)1, (int)this.handler1Calls);
    }

    @Test
    public void testTwoHandlers() {
        this.manager.addListener((CheatSheetListener)new Handler1());
        this.manager.addListener((CheatSheetListener)new Handler2());
        this.manager.fireEvent(2);
        Assertions.assertEquals((int)1, (int)this.handler1Calls);
        Assertions.assertEquals((int)1, (int)this.handler2Calls);
    }

    private class Handler1
    extends CheatSheetListener {
        private Handler1() {
        }

        public void cheatSheetEvent(ICheatSheetEvent event) {
            ++TestCheatSheetManagerEvents.this.handler1Calls;
        }
    }

    private class Handler2
    extends CheatSheetListener {
        private Handler2() {
        }

        public void cheatSheetEvent(ICheatSheetEvent event) {
            ++TestCheatSheetManagerEvents.this.handler2Calls;
        }
    }
}

