/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import org.assertj.core.api.Assertions;
import org.eclipse.ua.tests.cheatsheet.util.StatusCheck;
import org.eclipse.ua.tests.util.ResourceFinder;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.parser.CompositeCheatSheetParser;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class TestCompositeParser {
    private static final String COMPOSITES_FOLDER = "data/cheatsheet/composite/";
    private CompositeCheatSheetParser parser;

    @BeforeEach
    public void setUp() throws Exception {
        this.parser = new CompositeCheatSheetParser();
    }

    private CompositeCheatSheetModel parseTestFile(String path) {
        URL testURL = ResourceFinder.findFile(FrameworkUtil.getBundle(TestCompositeParser.class), COMPOSITES_FOLDER + path);
        return this.parser.parseGuide(testURL);
    }

    @Test
    public void testNullInput() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parser.parseGuide(null));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Could not open");
    }

    @Test
    public void testBadURL() {
        try {
            org.junit.jupiter.api.Assertions.assertNull((Object)this.parser.parseGuide(new URL("file:/nonexistent")));
        }
        catch (MalformedURLException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Exception thrown");
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Could not open");
    }

    @Test
    public void testSimpleGuide() {
        CompositeCheatSheetModel model = this.parseTestFile("SingleTask.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)model);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((EditableTask)model.getRootTask()).isSkippable());
    }

    @Test
    public void testNoTasks() {
        CompositeCheatSheetModel model = this.parseTestFile("GuideWithoutTasks.xml");
        org.junit.jupiter.api.Assertions.assertNull((Object)model);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Missing root task");
    }

    @Test
    public void testInvalidRoot() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("InvalidRoot.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Root node is not");
    }

    @Test
    public void testTwoRootTasksGuide() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("TwoRootTasks.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one root task");
    }

    @Test
    public void testParamNoName() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.parseTestFile("ParamNoName.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Parameter has no name");
    }

    @Test
    public void testParamNoValue() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.parseTestFile("ParamNoValue.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Parameter has no value");
    }

    @Test
    public void testValidParameters() {
        CompositeCheatSheetModel model = this.parseTestFile("ValidParameter.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)model);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        Dictionary params = model.getRootTask().getParameters();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)params.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", params.get("a"));
    }

    @Test
    public void testDependency() {
        CompositeCheatSheetModel model = this.parseTestFile("TaskDependency.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)model);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        AbstractTask task1 = model.getDependencies().getTask("task1");
        AbstractTask task2 = model.getDependencies().getTask("task2");
        Assertions.assertThat((Object[])task1.getRequiredTasks()).isEmpty();
        Assertions.assertThat((Object[])task1.getSuccessorTasks()).containsExactly((Object[])new ICompositeCheatSheetTask[]{task2});
        Assertions.assertThat((Object[])task2.getSuccessorTasks()).isEmpty();
        Assertions.assertThat((Object[])task2.getRequiredTasks()).containsExactly((Object[])new ICompositeCheatSheetTask[]{task1});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)task1.isSkippable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)task2.isSkippable());
    }

    @Test
    public void testBackwardDependency() {
        CompositeCheatSheetModel model = this.parseTestFile("BackwardDependency.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)model);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        AbstractTask task1 = model.getDependencies().getTask("task1");
        AbstractTask task2 = model.getDependencies().getTask("task2");
        Assertions.assertThat((Object[])task1.getRequiredTasks()).isEmpty();
        Assertions.assertThat((Object[])task1.getSuccessorTasks()).containsExactly((Object[])new ICompositeCheatSheetTask[]{task2});
        Assertions.assertThat((Object[])task2.getSuccessorTasks()).isEmpty();
        Assertions.assertThat((Object[])task2.getRequiredTasks()).containsExactly((Object[])new ICompositeCheatSheetTask[]{task1});
    }

    @Test
    public void testDependencyWithoutId() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("DependencyWithoutId.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Missing task id");
    }

    @Test
    public void testDependencyWithInvalidId() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("DependencyInvalidId.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Invalid id");
    }

    @Test
    public void testCircularDependency() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("CircularDependency.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertMultiStatusContains(this.parser.getStatus(), "Cycle detected");
    }

    @Test
    public void testSelfDependency() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("SelfDependency.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertMultiStatusContains(this.parser.getStatus(), "Cycle detected");
    }

    @Test
    public void testDuplicateId() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("DuplicateTaskId.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Duplicate task id");
    }

    @Test
    public void testNoTaskKind() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("LeafTaskWithoutKind.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Missing kind attribute in task");
    }

    @Test
    public void testLeafTaskInvalidKind() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("LeafTaskInvalidKind.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Invalid kind");
    }

    @Test
    public void testLeafTaskNoName() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("TaskNoName.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Missing name attribute in task");
    }

    @Test
    public void testCompositeNoName() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("CompositeNoName.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Missing name attribute in composite");
    }

    @Test
    public void testTaskGroupInvalidKind() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("InvalidTaskGroupKind.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Invalid kind");
    }

    @Test
    public void testSetNoChild() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("SetWithNoChildren.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Task group");
        StatusCheck.assertStatusContains(this.parser.getStatus(), "has no children");
    }

    @Test
    public void testChoiceNoChild() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.parseTestFile("EmptyChoice.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "has no children");
    }
}

