/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDependency {
    private CompositeCheatSheetModel model;
    private TaskGroup rootTask;
    private TaskGroup subGroup;
    private EditableTask task1;
    private EditableTask task2;
    private EditableTask task3;
    private EditableTask task4;

    private void setupModel() {
        this.model = new CompositeCheatSheetModel("name", "description", "explorerId");
        this.model.setId("org.eclipse.ua.tests.testPersistence");
        this.rootTask = new TaskGroup(this.model, "root", "name", "set");
        this.subGroup = new TaskGroup(this.model, "subGroup", "name", "set");
        this.task1 = new EditableTask(this.model, "task1", "name", "ua.junit");
        this.task2 = new EditableTask(this.model, "task2", "name", "ua.junit");
        this.task3 = new EditableTask(this.model, "task3", "name", "ua.junit");
        this.task4 = new EditableTask(this.model, "task4", "name", "ua.junit");
        this.model.setRootTask((ICompositeCheatSheetTask)this.rootTask);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.subGroup);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.task4);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task1);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task2);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task3);
    }

    @Test
    public void testDualDependency() {
        this.setupModel();
        this.task3.addRequiredTask((AbstractTask)this.task1);
        this.task3.addRequiredTask((AbstractTask)this.task2);
        Assertions.assertTrue((boolean)this.task1.requiredTasksCompleted());
        Assertions.assertTrue((boolean)this.task2.requiredTasksCompleted());
        Assertions.assertFalse((boolean)this.task3.requiredTasksCompleted());
        this.task1.complete();
        Assertions.assertFalse((boolean)this.task3.requiredTasksCompleted());
        this.task2.complete();
        Assertions.assertTrue((boolean)this.task3.requiredTasksCompleted());
    }

    @Test
    public void testSkippedDependency() {
        this.setupModel();
        this.task3.addRequiredTask((AbstractTask)this.task1);
        this.task3.addRequiredTask((AbstractTask)this.task2);
        Assertions.assertFalse((boolean)this.task3.requiredTasksCompleted());
        this.task1.complete();
        Assertions.assertFalse((boolean)this.task3.requiredTasksCompleted());
        this.task2.setState(2);
        Assertions.assertTrue((boolean)this.task3.requiredTasksCompleted());
    }

    @Test
    public void testGroupDependency() {
        this.setupModel();
        this.task4.addRequiredTask((AbstractTask)this.subGroup);
        Assertions.assertFalse((boolean)this.task4.requiredTasksCompleted());
        this.task1.complete();
        Assertions.assertFalse((boolean)this.task4.requiredTasksCompleted());
        this.task2.complete();
        Assertions.assertFalse((boolean)this.task4.requiredTasksCompleted());
        this.task3.complete();
        Assertions.assertTrue((boolean)this.task4.requiredTasksCompleted());
    }
}

