/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import java.io.StringReader;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.ui.internal.cheatsheets.composite.parser.MarkupParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TestMarkupParser {
    private Document readString(String input) {
        StringReader reader = new StringReader(input);
        InputSource source = new InputSource(reader);
        try {
            return LocalEntityResolver.parse((InputSource)source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private String parse(String input) {
        return MarkupParser.parseAndTrimTextMarkup((Node)this.readString(input).getFirstChild());
    }

    @Test
    public void testParseEmptyString() {
        Assertions.assertEquals((Object)"", (Object)this.parse("<root></root>"));
    }

    @Test
    public void testParseTags() {
        Assertions.assertEquals((Object)"a<b>c</b>d<b>e</b>", (Object)this.parse("<root>a<b>c</b>d<b>e</b></root>"));
    }

    @Test
    public void testParseNestedTags() {
        Assertions.assertEquals((Object)"<p>a<b>c</b>d</p>", (Object)this.parse("<root><p>a<b>c</b>d</p></root>"));
    }

    @Test
    public void testEscape() {
        Assertions.assertEquals((Object)"a&lt;b&gt;c", (Object)this.parse("<root>a&lt;b&gt;c</root>"));
    }

    @Test
    public void testEscapeAmpersand() {
        Assertions.assertEquals((Object)"a&amp;c", (Object)this.parse("<root>a&amp;c</root>"));
    }

    @Test
    public void testNoEscapeQuotes() {
        Assertions.assertEquals((Object)"a'b'\"c\"", (Object)this.parse("<root>a'b'\"c\"</root>"));
    }

    @Test
    public void testAttributes() {
        Assertions.assertEquals((Object)"a<b attr1 = \"true\" attr2 = \"false\">c</b>d<b>e</b>", (Object)this.parse("<root>a<b attr1 = \"true\" attr2=\"false\">c</b>d<b>e</b></root>"));
    }

    @Test
    public void testCreateParagraphEmptyString() {
        Assertions.assertEquals((Object)"<p></p>", (Object)MarkupParser.createParagraph((String)"", null));
    }

    @Test
    public void testCreateParagraphNoTags() {
        Assertions.assertEquals((Object)"<p>abc</p>", (Object)MarkupParser.createParagraph((String)"abc", null));
    }

    @Test
    public void testCreateParagraphTag_p() {
        Assertions.assertEquals((Object)"<p>abc</p>", (Object)MarkupParser.createParagraph((String)"<p>abc</p>", null));
    }

    @Test
    public void testCreateParagraphTag_br() {
        Assertions.assertEquals((Object)"<p><br>abc</p>", (Object)MarkupParser.createParagraph((String)"<br>abc", null));
    }

    @Test
    public void testCreateParagraphTag_li() {
        Assertions.assertEquals((Object)"<li>abc</li>", (Object)MarkupParser.createParagraph((String)"<li>abc</li>", null));
    }

    @Test
    public void testCreateParagraphWithImage_li() {
        Assertions.assertEquals((Object)"<p><img href=\"def\"/> abc</p>", (Object)MarkupParser.createParagraph((String)"abc", (String)"def"));
    }
}

